/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Core.items.custom;

import com.Infinity.Nexus.Core.component.CoreDataComponents;
import com.Infinity.Nexus.Core.items.ModItems;
import com.Infinity.Nexus.Core.utils.ModUtils;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class UpgradeItem
extends Item {
    public UpgradeItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltip, List<Component> components, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            if (stack.getItem() == ModItems.SPEED_UPGRADE.get()) {
                components.add((Component)Component.translatable((String)"item.infinity_nexus_core.speed_description"));
            } else if (stack.getItem() == ModItems.STRENGTH_UPGRADE.get()) {
                components.add((Component)Component.translatable((String)"item.infinity_nexus_core.strength_description"));
            } else if (stack.getItem() == ModItems.MUFFLER_UPGRADE.get()) {
                components.add((Component)Component.translatable((String)"item.infinity_nexus_core.muffler_description"));
            } else if (stack.getItem() == ModItems.PUSHER_UPGRADE.get()) {
                components.add((Component)Component.translatable((String)"item.infinity_nexus_core.pusher_description"));
                components.add((Component)Component.literal((String)("\u00a7c" + ((String)stack.getOrDefault(CoreDataComponents.PUSHER_DIRECTION, (Object)"up")).toUpperCase())));
            }
            components.add((Component)Component.translatable((String)"tooltip.infinity_nexus_core.upgrade_install"));
        } else {
            components.add((Component)Component.translatable((String)"tooltip.infinity_nexus_core.pressShift"));
            if (stack.getItem() == ModItems.PUSHER_UPGRADE.get()) {
                components.add((Component)Component.literal((String)("\u00a7c" + ((String)stack.getOrDefault(CoreDataComponents.PUSHER_DIRECTION, (Object)"up")).toUpperCase())));
            }
        }
        super.appendHoverText(stack, tooltip, components, flag);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack mainHand;
        if (!level.isClientSide() && player.isShiftKeyDown() && (mainHand = player.getMainHandItem()).getItem().equals(ModItems.PUSHER_UPGRADE.get())) {
            String side = ModUtils.cycleSideValue((String)mainHand.getOrDefault(CoreDataComponents.PUSHER_DIRECTION, (Object)"up"));
            mainHand.set(CoreDataComponents.PUSHER_DIRECTION, (Object)side);
            level.playSound(null, player.blockPosition(), SoundEvents.UI_STONECUTTER_TAKE_RESULT, SoundSource.BLOCKS, 0.1f, 1.0f);
        }
        return super.use(level, player, usedHand);
    }
}

