/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Core.commands.cp;

import com.Infinity.Nexus.Core.commands.CopyPaste;
import com.Infinity.Nexus.Core.commands.cp.CopiedArea;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;

public class Export {
    public static int save(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player == null) {
            return 0;
        }
        Object filename = StringArgumentType.getString(context, (String)"name");
        String playerName = player.getName().getString();
        CopiedArea area = CopyPaste.playerSessions.get(playerName);
        if (area == null) {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a7bINC\u00a7f]: \u00a7cError: You need to copy an area first!"));
            return 0;
        }
        if (!((String)filename).endsWith(".nbt")) {
            filename = (String)filename + ".nbt";
        }
        Path schematicsDir = Path.of("config/infinitynexuscore/schematics", new String[0]);
        try {
            Files.createDirectories(schematicsDir, new FileAttribute[0]);
            CompoundTag schematicTag = Export.createSchematicTag(area);
            NbtIo.writeCompressed((CompoundTag)schematicTag, (Path)schematicsDir.resolve((String)filename));
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7f[\u00a7bINC\u00a7f]: \u00a7aSchematic saved successfully as \u00a7e" + (String)filename)));
            return 1;
        }
        catch (IOException e) {
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7f[\u00a7bINC\u00a7f]: \u00a7cError saving schematic: " + e.getMessage())));
            return 0;
        }
    }

    private static CompoundTag createSchematicTag(CopiedArea area) {
        CompoundTag schematicTag = new CompoundTag();
        BlockPos min = new BlockPos(Math.min(area.pos1.getX(), area.pos2.getX()), Math.min(area.pos1.getY(), area.pos2.getY()), Math.min(area.pos1.getZ(), area.pos2.getZ()));
        BlockPos max = new BlockPos(Math.max(area.pos1.getX(), area.pos2.getX()), Math.max(area.pos1.getY(), area.pos2.getY()), Math.max(area.pos1.getZ(), area.pos2.getZ()));
        int width = max.getX() - min.getX() + 1;
        int height = max.getY() - min.getY() + 1;
        int length = max.getZ() - min.getZ() + 1;
        ListTag size = new ListTag();
        size.add((Object)IntTag.valueOf((int)width));
        size.add((Object)IntTag.valueOf((int)height));
        size.add((Object)IntTag.valueOf((int)length));
        schematicTag.put("size", (Tag)size);
        ListTag palette = new ListTag();
        HashMap<BlockState, Integer> paletteMap = new HashMap<BlockState, Integer>();
        ListTag blocks = new ListTag();
        ListTag entities = new ListTag();
        for (Map.Entry<BlockPos, BlockState> entry : area.blocks.entrySet()) {
            BlockState state = entry.getValue();
            if (!area.includeAir && state.isAir() || !area.includeWater && state.getBlock() instanceof LiquidBlock || paletteMap.containsKey(state)) continue;
            paletteMap.put(state, paletteMap.size());
            palette.add((Object)Export.createPaletteEntry(state));
        }
        for (Map.Entry<BlockPos, BlockState> entry : area.blocks.entrySet()) {
            BlockPos relativePos = entry.getKey();
            BlockState state = entry.getValue();
            if (!area.includeAir && state.isAir() || !area.includeWater && state.getBlock() instanceof LiquidBlock) continue;
            CompoundTag blockTag = new CompoundTag();
            ListTag pos = new ListTag();
            pos.add((Object)IntTag.valueOf((int)relativePos.getX()));
            pos.add((Object)IntTag.valueOf((int)relativePos.getY()));
            pos.add((Object)IntTag.valueOf((int)relativePos.getZ()));
            blockTag.put("pos", (Tag)pos);
            int stateIndex = (Integer)paletteMap.get(state);
            blockTag.putInt("state", stateIndex);
            if (area.includeBE && area.blockEntities.containsKey(relativePos)) {
                CompoundTag beTag = area.blockEntities.get(relativePos).copy();
                CompoundTag cleanBeTag = new CompoundTag();
                if (beTag.contains("Items")) {
                    cleanBeTag.put("Items", (Tag)beTag.getList("Items", 10));
                }
                if (beTag.contains("TransferCooldown")) {
                    cleanBeTag.putInt("TransferCooldown", beTag.getInt("TransferCooldown"));
                }
                if (beTag.contains("id")) {
                    cleanBeTag.putString("id", beTag.getString("id"));
                }
                blockTag.put("nbt", (Tag)cleanBeTag);
            }
            blocks.add((Object)blockTag);
        }
        schematicTag.put("blocks", (Tag)blocks);
        schematicTag.put("entities", (Tag)entities);
        schematicTag.put("palette", (Tag)palette);
        schematicTag.putInt("DataVersion", SharedConstants.getCurrentVersion().getDataVersion().getVersion());
        return schematicTag;
    }

    private static CompoundTag createPaletteEntry(BlockState state) {
        CompoundTag entry = new CompoundTag();
        entry.putString("Name", BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).toString());
        if (!state.getValues().isEmpty()) {
            CompoundTag properties = new CompoundTag();
            state.getValues().forEach((prop, value) -> properties.putString(prop.getName(), value.toString()));
            entry.put("Properties", (Tag)properties);
        }
        return entry;
    }
}

