/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Core.commands.cp;

import com.Infinity.Nexus.Core.commands.CopyPaste;
import com.Infinity.Nexus.Core.commands.cp.CopiedArea;
import com.Infinity.Nexus.Core.utils.GetResourceLocation;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class Import {
    private static final long MAX_SCHEMATIC_SIZE = 0xA00000L;
    private static final int MAX_PALETTE_SIZE = 65536;
    private static final int MAX_DIMENSION = 1024;

    public static int load(CommandContext<CommandSourceStack> context) {
        Path schematicsDir;
        Path schematicFile;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player == null) {
            return 0;
        }
        Object filename = StringArgumentType.getString(context, (String)"name");
        String playerName = player.getName().getString();
        if (!((String)filename).endsWith(".nbt")) {
            filename = (String)filename + ".nbt";
        }
        if (!Files.exists(schematicFile = (schematicsDir = Path.of("config/infinitynexuscore/schematics", new String[0])).resolve((String)filename), new LinkOption[0])) {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a7bINC\u00a7f]: \u00a7cError: Schematic file not found!"));
            return 0;
        }
        try {
            NbtAccounter accounter = new NbtAccounter(0xA00000L, 512);
            CompoundTag schematicTag = NbtIo.readCompressed((Path)schematicFile, (NbtAccounter)accounter);
            ListTag sizeTag = schematicTag.getList("size", 3);
            int width = sizeTag.getInt(0);
            int height = sizeTag.getInt(1);
            int length = sizeTag.getInt(2);
            ListTag paletteTag = schematicTag.getList("palette", 10);
            BlockState[] palette = new BlockState[paletteTag.size()];
            for (int i = 0; i < paletteTag.size(); ++i) {
                CompoundTag entry = paletteTag.getCompound(i);
                Block block = (Block)BuiltInRegistries.BLOCK.get(GetResourceLocation.parse(entry.getString("Name")));
                Object state = block.defaultBlockState();
                if (entry.contains("Properties")) {
                    CompoundTag properties = entry.getCompound("Properties");
                    for (String key : properties.getAllKeys()) {
                        Property property = block.getStateDefinition().getProperty(key);
                        if (property == null) continue;
                        state = Import.setProperty((BlockState)state, property, properties.getString(key));
                    }
                }
                palette[i] = state;
            }
            ListTag blocksTag = schematicTag.getList("blocks", 10);
            HashMap<BlockPos, BlockState> blocks = new HashMap<BlockPos, BlockState>();
            HashMap<BlockPos, CompoundTag> blockEntities = new HashMap<BlockPos, CompoundTag>();
            for (Tag tag : blocksTag) {
                CompoundTag blockTag = (CompoundTag)tag;
                ListTag posTag = blockTag.getList("pos", 3);
                BlockPos pos = new BlockPos(posTag.getInt(0), posTag.getInt(1), posTag.getInt(2));
                int stateIndex = blockTag.getInt("state");
                if (stateIndex >= 0 && stateIndex < palette.length) {
                    blocks.put(pos, palette[stateIndex]);
                }
                if (!blockTag.contains("nbt")) continue;
                blockEntities.put(pos, blockTag.getCompound("nbt"));
            }
            BlockPos pos1 = player.blockPosition();
            BlockPos pos2 = pos1.offset(width - 1, height - 1, length - 1);
            BlockPos playerRelativePos = BlockPos.ZERO;
            CopyPaste.playerSessions.put(playerName, new CopiedArea(((String)filename).replace(".nbt", ""), pos1, pos2, playerRelativePos, blocks, blockEntities, true, true, true, true));
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a7bINC\u00a7f]: \u00a7aSchematic loaded successfully! Use \u00a7e//paste \u00a7ato paste it."));
            return 1;
        }
        catch (IOException e) {
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7f[\u00a7bINC\u00a7f]: \u00a7cError loading schematic: " + e.getMessage())));
            return 0;
        }
    }

    private static <T extends Comparable<T>> BlockState setProperty(BlockState state, Property<T> property, String value) {
        return property.getValue(value).map(v -> (BlockState)state.setValue(property, v)).orElse(state);
    }
}

