/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Core.commands.cp;

import com.Infinity.Nexus.Core.commands.CopyPaste;
import com.Infinity.Nexus.Core.commands.cp.CopiedArea;
import com.Infinity.Nexus.Core.commands.cp.PasteHistory;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class Paste {
    private static final Map<String, PasteTask> activePastes = new HashMap<String, PasteTask>();

    public static int paste(CommandContext<CommandSourceStack> context, boolean includeAir, boolean includeBE, boolean includeFluids) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player == null) {
            return 0;
        }
        String playerName = player.getName().getString();
        if (activePastes.containsKey(playerName)) {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a7bINC\u00a7f]: \u00a7cError: You already have a paste in progress!"));
            return 0;
        }
        CopiedArea area = CopyPaste.playerSessions.get(playerName);
        if (area == null) {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a7bINC\u00a7f]: \u00a7cError: You haven't copied any area yet!"));
            return 0;
        }
        ServerLevel world = ((CommandSourceStack)context.getSource()).getLevel();
        BlockPos playerPos = player.blockPosition();
        BlockPos pasteOrigin = playerPos.subtract((Vec3i)area.playerRelativePos);
        PasteTask task = new PasteTask(player, world, area, pasteOrigin, includeAir, includeBE, includeFluids);
        activePastes.put(playerName, task);
        Paste.scheduleNextTick(player.getServer(), playerName);
        player.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a7bINC\u00a7f]: \u00a7aStarting paste operation..."));
        return 1;
    }

    private static void scheduleNextTick(MinecraftServer server, String playerName) {
        server.tell((Runnable)new TickTask(server.getTickCount() + 5, () -> {
            PasteTask task = activePastes.get(playerName);
            if (task != null) {
                if (!task.processNextBlock()) {
                    activePastes.remove(playerName);
                    task.sendCompletionMessage();
                } else {
                    Paste.scheduleNextTick(server, playerName);
                }
            }
        }));
    }

    private static BlockState rotateBlockState(BlockState state, int rotation) {
        return switch (rotation) {
            case 90 -> state.rotate(Rotation.CLOCKWISE_90);
            case 180 -> state.rotate(Rotation.CLOCKWISE_180);
            case 270 -> state.rotate(Rotation.COUNTERCLOCKWISE_90);
            default -> state;
        };
    }

    private static BlockPos rotatePosition(BlockPos pos, int rotation) {
        return switch (rotation) {
            case 90 -> new BlockPos(-pos.getZ(), pos.getY(), pos.getX());
            case 180 -> new BlockPos(-pos.getX(), pos.getY(), -pos.getZ());
            case 270 -> new BlockPos(pos.getZ(), pos.getY(), -pos.getX());
            default -> pos;
        };
    }

    private static class PasteTask {
        private final ServerPlayer player;
        private final ServerLevel world;
        private final CopiedArea area;
        private final BlockPos pasteOrigin;
        private final boolean includeAir;
        private final boolean includeBE;
        private final boolean includeFluids;
        private final Iterator<Map.Entry<BlockPos, BlockState>> blockIterator;
        private final Map<BlockPos, BlockState> replacedBlocks = new HashMap<BlockPos, BlockState>();
        private final Map<BlockPos, CompoundTag> replacedBlockEntities = new HashMap<BlockPos, CompoundTag>();
        private int airBlocks = 0;
        private int blockEntities = 0;
        private int fluidBlocks = 0;
        private int blocksPasted = 0;

        public PasteTask(ServerPlayer player, ServerLevel world, CopiedArea area, BlockPos pasteOrigin, boolean includeAir, boolean includeBE, boolean includeFluids) {
            this.player = player;
            this.world = world;
            this.area = area;
            this.pasteOrigin = pasteOrigin;
            this.includeAir = includeAir;
            this.includeBE = includeBE;
            this.includeFluids = includeFluids;
            this.blockIterator = area.blocks.entrySet().iterator();
        }

        public boolean processNextBlock() {
            if (!this.blockIterator.hasNext()) {
                return false;
            }
            Map.Entry<BlockPos, BlockState> entry = this.blockIterator.next();
            BlockPos relativeToReference = entry.getKey().subtract((Vec3i)this.area.playerRelativePos);
            BlockPos rotatedRelative = Paste.rotatePosition(relativeToReference, this.area.rotation);
            BlockPos absolutePos = this.pasteOrigin.offset((Vec3i)this.area.playerRelativePos).offset((Vec3i)rotatedRelative);
            if (absolutePos.getY() >= this.world.getMinBuildHeight() && absolutePos.getY() < this.world.getMaxBuildHeight()) {
                BlockEntity newBlockEntity;
                BlockState stateToPaste = Paste.rotateBlockState(entry.getValue(), this.area.rotation);
                if (!this.includeAir && stateToPaste.isAir()) {
                    ++this.airBlocks;
                    return true;
                }
                if (!this.includeBE && stateToPaste.hasBlockEntity()) {
                    ++this.blockEntities;
                    return true;
                }
                if (!this.includeFluids && (stateToPaste.getBlock() instanceof LiquidBlock || stateToPaste.getFluidState().isSource())) {
                    ++this.fluidBlocks;
                    return true;
                }
                this.replacedBlocks.put(absolutePos, this.world.getBlockState(absolutePos));
                BlockEntity blockEntity = this.world.getBlockEntity(absolutePos);
                if (blockEntity != null) {
                    CompoundTag tag = blockEntity.saveWithFullMetadata((HolderLookup.Provider)this.world.registryAccess());
                    this.replacedBlockEntities.put(absolutePos, tag);
                }
                this.world.setBlock(absolutePos, stateToPaste, 3);
                CompoundTag blockEntityTag = this.area.blockEntities.get(entry.getKey());
                if (blockEntityTag != null && (newBlockEntity = this.world.getBlockEntity(absolutePos)) != null) {
                    newBlockEntity.loadCustomOnly(blockEntityTag, (HolderLookup.Provider)this.world.registryAccess());
                    newBlockEntity.setChanged();
                }
                ++this.blocksPasted;
            }
            return true;
        }

        public void sendCompletionMessage() {
            CopyPaste.playerHistory.computeIfAbsent(this.player.getName().getString(), k -> new ArrayDeque()).push(new PasteHistory(this.replacedBlocks, this.replacedBlockEntities));
            this.player.sendSystemMessage((Component)Component.literal((String)("\u00a7f[\u00a7bINC\u00a7f]: \u00a7aPaste completed! \u00a7e" + this.area.blocks.size() + " \u00a7ablocks processed: \u00a7f" + this.airBlocks + " \u00a7aAir, \u00a7b" + this.fluidBlocks + " \u00a7aFluids, \u00a75" + this.blockEntities + " \u00a7aBlockEntities")));
        }
    }
}

