/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Core.commands.cp;

import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;

public class SchematicList {
    public static int list(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player == null) {
            return 0;
        }
        try {
            List schematics;
            Path schematicsDir = Path.of("config/infinitynexuscore/schematics", new String[0]);
            if (!Files.exists(schematicsDir, new LinkOption[0])) {
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a7bINC\u00a7f]: \u00a7cNo schematics directory found"));
                return 0;
            }
            try (Stream<Path> paths = Files.list(schematicsDir);){
                schematics = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".nbt")).collect(Collectors.toList());
            }
            if (schematics.isEmpty()) {
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a7bINC\u00a7f]: \u00a7cNo schematics found"));
                return 0;
            }
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7f[\u00a7bINC\u00a7f]: \u00a7aAvailable schematics:"));
            String first = "\u251c";
            for (Path schematic : schematics) {
                String fileName = schematic.getFileName().toString().replace(".nbt", "");
                MutableComponent message = Component.literal((String)("\u00a7f" + first + "\u00a7f[\u00a7e\u00a7o" + fileName + "\u00a7f]")).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "// schematic load " + fileName)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"\u00a7aClick to load schematic"))));
                first = schematics.indexOf(schematic) == schematics.size() - 2 ? "\u2514" : "\u251c";
                player.sendSystemMessage((Component)message);
            }
            return 1;
        }
        catch (IOException e) {
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7f[\u00a7bINC\u00a7f]: \u00a7cError listing schematics: " + e.getMessage())));
            return 0;
        }
    }
}

