/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Core.component;

import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.common.util.LogicalSidedProvider;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class CoreDataComponents {
    public static final DeferredRegister<DataComponentType<?>> DATA_COMPONENT_TYPES = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"infinity_nexus_core");
    public static final Supplier<DataComponentType<Integer>> ANCESTRAL_COMPONENT_USES = CoreDataComponents.register("ancestral_component_uses", () -> 1, op -> op.persistent((Codec)Codec.INT));
    public static final Supplier<DataComponentType<Boolean>> ANCESTRAL_COMPONENT_DURABILITY = CoreDataComponents.register("ancestral_component_durability", () -> false, op -> op.persistent((Codec)Codec.BOOL));
    public static final Supplier<DataComponentType<String>> PUSHER_DIRECTION = CoreDataComponents.register("pusher_direction", () -> "up", op -> op.persistent((Codec)Codec.STRING));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<BlockPos>> LINKINGTOOL_COORDS = CoreDataComponents.register("linkingtool_coords", op -> op.persistent(BlockPos.CODEC));
    public static final Supplier<DataComponentType<Boolean>> GOLDEN_AXE_EDITOR = CoreDataComponents.register("golden_axe_editor", () -> false, op -> op.persistent((Codec)Codec.BOOL));

    private static <T> ComponentSupplier<T> register(String name, Supplier<T> defaultVal, UnaryOperator<DataComponentType.Builder<T>> op) {
        DeferredHolder registered = DATA_COMPONENT_TYPES.register(name, () -> ((DataComponentType.Builder)op.apply(DataComponentType.builder())).build());
        return new ComponentSupplier<T>(registered, defaultVal);
    }

    private static <T> DeferredHolder<DataComponentType<?>, DataComponentType<T>> register(String name, UnaryOperator<DataComponentType.Builder<T>> builderOperator) {
        return DATA_COMPONENT_TYPES.register(name, () -> ((DataComponentType.Builder)builderOperator.apply(DataComponentType.builder())).build());
    }

    public static RegistryAccess registryAccess() {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            return ServerLifecycleHooks.getCurrentServer().registryAccess();
        }
        return ((Level)((Optional)LogicalSidedProvider.CLIENTWORLD.get(LogicalSide.CLIENT)).orElseThrow()).registryAccess();
    }

    public static class ComponentSupplier<T>
    implements Supplier<DataComponentType<T>> {
        private final Supplier<DataComponentType<T>> type;
        private final Supplier<T> defaultSupplier;

        public ComponentSupplier(Supplier<DataComponentType<T>> type, Supplier<T> defaultSupplier) {
            this.type = type;
            this.defaultSupplier = Suppliers.memoize(defaultSupplier::get);
        }

        public T get(ItemStack stack) {
            return (T)stack.getOrDefault(this.type, this.defaultSupplier.get());
        }

        @Override
        public DataComponentType<T> get() {
            return this.type.get();
        }
    }
}

