/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Core.events;

import com.Infinity.Nexus.Core.commands.CopyPaste;
import com.Infinity.Nexus.Core.component.CoreDataComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="infinity_nexus_core")
public class Listeners {
    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        event.setCanceled(Listeners.handleAxeInteraction(event.getEntity(), event.getPos(), true));
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        event.setCanceled(Listeners.handleAxeInteraction(event.getEntity(), event.getPos(), false));
    }

    private static boolean handleAxeInteraction(Player player, BlockPos pos, boolean isLeftClick) {
        if (!(player instanceof ServerPlayer) || player.isSpectator()) {
            return false;
        }
        ItemStack handItem = player.getMainHandItem();
        if (handItem.is(Items.GOLDEN_AXE) && player.hasPermissions(4) && handItem.has(CoreDataComponents.GOLDEN_AXE_EDITOR)) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            String playerName = player.getName().getString();
            if (isLeftClick) {
                CopyPaste.playerPos1.put(playerName, pos);
                serverPlayer.sendSystemMessage((Component)Component.literal((String)("\u00a7f[\u00a7bINC\u00a7f]: \u00a7aPos1 set to: \u00a7e" + pos.toShortString() + " \u00a7a(Left-click with golden axe)")));
            } else {
                CopyPaste.playerPos2.put(playerName, pos);
                serverPlayer.sendSystemMessage((Component)Component.literal((String)("\u00a7f[\u00a7bINC\u00a7f]: \u00a7aPos2 set to: \u00a7e" + pos.toShortString() + " \u00a7a(Right-click with golden axe)")));
            }
            return true;
        }
        return false;
    }
}

