/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Core.items.custom;

import com.Infinity.Nexus.Core.component.CoreDataComponents;
import com.Infinity.Nexus.Core.items.ModItems;
import com.Infinity.Nexus.Core.utils.ModUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public class ComponentItem
extends Item {
    private final String durability;

    public ComponentItem(Item.Properties pProperties, String durability) {
        super(pProperties);
        this.durability = durability;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltip, List<Component> components, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            components.add((Component)Component.literal((String)("\u00a7eLevel: \u00a79" + ModUtils.getComponentLevel(stack))));
            if (stack.getItem() == ModItems.ANCESTRAL_COMPONENT.get()) {
                components.add((Component)Component.literal((String)("\u00a72Uses:" + (stack.has(CoreDataComponents.ANCESTRAL_COMPONENT_DURABILITY) ? " \u00a75\u221e " : " ") + "\u00a7e" + (stack.has(CoreDataComponents.ANCESTRAL_COMPONENT_USES) ? (Integer)stack.get(CoreDataComponents.ANCESTRAL_COMPONENT_USES) : 1))));
                components.add((Component)Component.translatable((String)"tooltip.infinity_nexus_core.infinity_ancestral_component"));
            } else {
                components.add((Component)Component.literal((String)this.durability));
            }
            components.add((Component)Component.translatable((String)"tooltip.infinity_nexus_core.component_install"));
            super.appendHoverText(stack, tooltip, components, flag);
        } else {
            components.add((Component)Component.translatable((String)"tooltip.infinity_nexus_core.pressShift"));
        }
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (!pLevel.isClientSide()) {
            ItemStack mainHand = pPlayer.getMainHandItem();
            ItemStack offHand = pPlayer.getOffhandItem();
            if (mainHand.getItem().equals(ModItems.ANCESTRAL_COMPONENT.get()) && !((Boolean)mainHand.getOrDefault(CoreDataComponents.ANCESTRAL_COMPONENT_DURABILITY, (Object)false)).booleanValue() && offHand.getItem().equals(ModItems.INFINITY_COMPONENT.get())) {
                pPlayer.getMainHandItem().setDamageValue(0);
                mainHand.set(CoreDataComponents.ANCESTRAL_COMPONENT_DURABILITY, (Object)true);
                offHand.shrink(1);
            }
        }
        return super.use(pLevel, pPlayer, pUsedHand);
    }

    public int getEnchantmentValue() {
        return 8;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        ArrayList<ResourceKey> enchantments = new ArrayList<ResourceKey>();
        enchantments.add(Enchantments.UNBREAKING);
        enchantments.add(Enchantments.MENDING);
        return enchantments.contains(enchantment.getKey());
    }

    public boolean isFoil(ItemStack pStack) {
        return Boolean.TRUE.equals(pStack.get(CoreDataComponents.ANCESTRAL_COMPONENT_DURABILITY));
    }
}

