/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Core.utils;

import com.Infinity.Nexus.Core.itemStackHandler.RestrictedItemStackHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class FluidUtils {
    public static boolean isFluidHandlerItem(ItemStack stack) {
        return stack.getCapability(Capabilities.FluidHandler.ITEM) != null;
    }

    public static boolean isSameFluid(FluidStack fluid1, FluidStack fluid2) {
        return fluid1.getFluid().isSame(fluid2.getFluid());
    }

    public static boolean canTankAcceptFluid(FluidTank tank, FluidStack stack) {
        return tank.isFluidValid(stack) && tank.fill(stack, IFluidHandler.FluidAction.SIMULATE) > 0;
    }

    public static IFluidHandler getFluidItemHandler(ItemStack stack) {
        if (FluidUtils.isFluidHandlerItem(stack)) {
            return (IFluidHandler)stack.getCapability(Capabilities.FluidHandler.ITEM);
        }
        return null;
    }

    public static int transferFromItemToTank(FluidTank tank, RestrictedItemStackHandler itemHandler, int OUTPUT_FLUID_SLOT, int INPUT_FLUID_SLOT) {
        ItemStack itemStack = itemHandler.getStackInSlot(INPUT_FLUID_SLOT);
        if (itemStack.getItem() instanceof BucketItem) {
            return FluidUtils.drainBucketToTank(tank, itemHandler, INPUT_FLUID_SLOT, OUTPUT_FLUID_SLOT);
        }
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler == null) {
            return 0;
        }
        FluidStack drained = fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        int fillableAmount = tank.fill(drained, IFluidHandler.FluidAction.SIMULATE);
        if (fillableAmount <= 0) {
            return 0;
        }
        drained = fluidHandler.drain(fillableAmount, IFluidHandler.FluidAction.EXECUTE);
        int actuallyFilled = tank.fill(drained, IFluidHandler.FluidAction.EXECUTE);
        return actuallyFilled;
    }

    public static int transferFromTankToItem(FluidTank tank, RestrictedItemStackHandler itemHandler, int OUTPUT_FLUID_SLOT, int INPUT_FLUID_SLOT) {
        ItemStack itemStack = itemHandler.getStackInSlot(INPUT_FLUID_SLOT);
        if (itemStack.getItem() instanceof BucketItem) {
            FluidUtils.fillBucketFromTank(tank, itemHandler, INPUT_FLUID_SLOT, OUTPUT_FLUID_SLOT);
            return 0;
        }
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler == null) {
            return 0;
        }
        FluidStack tankFluid = tank.getFluid();
        int fillableAmount = fluidHandler.fill(tankFluid, IFluidHandler.FluidAction.SIMULATE);
        if (fillableAmount <= 0) {
            return 0;
        }
        FluidStack drained = tank.drain(fillableAmount, IFluidHandler.FluidAction.EXECUTE);
        int actuallyFilled = fluidHandler.fill(drained, IFluidHandler.FluidAction.EXECUTE);
        return actuallyFilled;
    }

    public static int fillBucketFromTank(FluidTank tank, RestrictedItemStackHandler itemHandler, int bucketSlot, int outputSlot) {
        if (tank.getFluid().isEmpty() || tank.getFluidAmount() < 1000) {
            return 0;
        }
        ItemStack bucket = itemHandler.getStackInSlot(bucketSlot);
        if (bucket.getItem() != Items.BUCKET || bucket.getCount() < 1) {
            return 0;
        }
        ItemStack outputStack = itemHandler.getStackInSlot(outputSlot);
        if (!(outputStack.isEmpty() || outputStack.is(tank.getFluid().getFluid().getBucket()) && outputStack.getCount() < outputStack.getMaxStackSize())) {
            return 0;
        }
        ItemStack filledBucket = tank.getFluid().getFluidType().getBucket(tank.getFluid());
        if (filledBucket.isEmpty()) {
            return 0;
        }
        tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
        itemHandler.extractItem(bucketSlot, 1, false, false);
        if (outputStack.isEmpty()) {
            itemHandler.setStackInSlot(outputSlot, filledBucket);
        } else {
            outputStack.grow(1);
        }
        return 1000;
    }

    public static int drainBucketToTank(FluidTank tank, RestrictedItemStackHandler itemHandler, int bucketSlot, int outputSlot) {
        BucketItem bucketItem;
        block10: {
            block9: {
                if (tank.getSpace() <= 1000) {
                    return 0;
                }
                ItemStack bucket = itemHandler.getStackInSlot(bucketSlot);
                Item item = bucket.getItem();
                if (!(item instanceof BucketItem)) break block9;
                bucketItem = (BucketItem)item;
                if (!bucket.isEmpty()) break block10;
            }
            return 0;
        }
        FluidStack fluidStack = new FluidStack(bucketItem.content, 1000);
        if (!tank.isEmpty() && !FluidUtils.isSameFluid(fluidStack, tank.getFluid())) {
            return 0;
        }
        ItemStack outputStack = itemHandler.getStackInSlot(outputSlot);
        if (!(outputStack.isEmpty() || outputStack.is(Items.BUCKET) && outputStack.getCount() < outputStack.getMaxStackSize())) {
            return 0;
        }
        int filled = tank.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE);
        if (filled == 1000) {
            tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            itemHandler.extractItem(bucketSlot, 1, false, false);
            if (outputStack.isEmpty()) {
                itemHandler.setStackInSlot(outputSlot, new ItemStack((ItemLike)Items.BUCKET));
            } else {
                outputStack.grow(1);
            }
            return 1000;
        }
        return 0;
    }

    public static boolean containsFluid(ItemStack itemStack, FluidStack fluidStack) {
        IFluidHandlerItem handler = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
        if (handler == null) {
            return false;
        }
        FluidStack containedFluid = handler.getFluidInTank(0);
        return containedFluid.is(fluidStack.getFluid());
    }

    public static int getFluidAmountInItem(ItemStack itemStack) {
        IFluidHandlerItem handler = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
        if (handler == null) {
            return 0;
        }
        return handler.getFluidInTank(0).getAmount();
    }

    public static int getItemFluidCapacity(ItemStack itemStack) {
        IFluidHandlerItem handler = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
        if (handler == null) {
            return 0;
        }
        return handler.getTankCapacity(0);
    }

    public static FluidStack getFluidInItem(ItemStack itemStack) {
        IFluidHandlerItem handler = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
        if (handler == null) {
            return FluidStack.EMPTY;
        }
        return handler.getFluidInTank(0);
    }

    public static boolean isBlockFluidHandler(BlockPos pos, Level level) {
        return level.getCapability(Capabilities.FluidHandler.BLOCK, pos, null) != null;
    }

    public static void transferFromTankToTank(FluidTank toOutput, FluidTank toInput, int amount) {
        FluidStack drained = toOutput.drain(amount, IFluidHandler.FluidAction.SIMULATE);
        int fillableAmount = toInput.fill(drained, IFluidHandler.FluidAction.SIMULATE);
        if (fillableAmount <= 0) {
            return;
        }
        toInput.fill(toOutput.drain(fillableAmount, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
    }

    public static void transferFromTankToTank(IFluidHandler toOutput, FluidTank toInput, int amount) {
        FluidStack drained = toOutput.drain(amount, IFluidHandler.FluidAction.SIMULATE);
        int fillableAmount = toInput.fill(drained, IFluidHandler.FluidAction.SIMULATE);
        if (fillableAmount <= 0) {
            return;
        }
        toInput.fill(toOutput.drain(fillableAmount, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
    }

    public static void transferFromTankToTank(FluidTank toOutput, IFluidHandler toInput, int amount) {
        FluidStack drained = toOutput.drain(amount, IFluidHandler.FluidAction.SIMULATE);
        int fillableAmount = toInput.fill(drained, IFluidHandler.FluidAction.SIMULATE);
        if (fillableAmount <= 0) {
            return;
        }
        toInput.fill(toOutput.drain(fillableAmount, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
    }

    public static void transferFromTankToTank(IFluidHandler toOutput, IFluidHandler toInput, int amount) {
        FluidStack drained = toOutput.drain(amount, IFluidHandler.FluidAction.SIMULATE);
        int fillableAmount = toInput.fill(drained, IFluidHandler.FluidAction.SIMULATE);
        if (fillableAmount <= 0) {
            return;
        }
        toInput.fill(toOutput.drain(fillableAmount, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
    }

    public static IFluidHandler getBlockFluidHandler(BlockPos pos, Level level) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity == null) {
            return null;
        }
        return (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos, null);
    }

    public static FluidStack getFluidStack(BlockPos pos, Level level) {
        if (!FluidUtils.isBlockFluidHandler(pos, level)) {
            return FluidStack.EMPTY;
        }
        FluidStack fluidStack = FluidUtils.getBlockFluidHandler(pos, level).getFluidInTank(0);
        return fluidStack == null ? fluidStack : FluidStack.EMPTY;
    }

    public static boolean canInsertFluid(BlockPos pos, Level level, FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return false;
        }
        if (!FluidUtils.isBlockFluidHandler(pos, level)) {
            return false;
        }
        IFluidHandler tank = FluidUtils.getBlockFluidHandler(pos, level);
        int tankCapacity = tank.getTankCapacity(0);
        int fluidAmount = fluidStack.getAmount();
        return fluidAmount <= tankCapacity && tank.isFluidValid(0, fluidStack);
    }

    public static void drainFluidFromTank(FluidTank tank, int amount) {
        if (amount <= 0 || tank.getFluidAmount() <= 0) {
            return;
        }
        tank.drain(amount, IFluidHandler.FluidAction.EXECUTE);
    }

    public static void drainFluidFromTank(IFluidHandler tank, int tankIndex, int amount) {
        if (amount <= 0 || tank.getTankCapacity(tankIndex) <= 0) {
            return;
        }
        tank.drain(new FluidStack(tank.getFluidInTank(tankIndex).getFluid(), amount), IFluidHandler.FluidAction.EXECUTE);
    }

    public static void fillFluidToTank(FluidTank tank, FluidStack fluidStack) {
        if (fluidStack.isEmpty() || tank.getSpace() < fluidStack.getAmount()) {
            return;
        }
        if (!tank.isEmpty() && !FluidUtils.isSameFluid(fluidStack, tank.getFluid())) {
            return;
        }
        tank.fill(fluidStack.copy(), IFluidHandler.FluidAction.EXECUTE);
    }

    public static void fillFluidToTank(IFluidHandler tank, FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return;
        }
        FluidStack tankFluid = tank.getFluidInTank(0);
        int freeSpace = tank.getTankCapacity(0) - tankFluid.getAmount();
        if (freeSpace < fluidStack.getAmount()) {
            return;
        }
        if (!tankFluid.isEmpty() && !FluidUtils.isSameFluid(fluidStack, tankFluid)) {
            return;
        }
        tank.fill(fluidStack.copy(), IFluidHandler.FluidAction.EXECUTE);
    }
}

