#All of the code below is part of the Holidays & Happenings datapack created by BeagleBlocks

#----------------------------------------------------------------------------------- Player Authentication ---------------------------------------------------------------------------------------------#
execute as @a[tag=!authenticating] at @s run function hh:player/authenticate

#Recipe Enabling
execute as @a[tag=!recipehh] at @s run function hh:player/recipe

#Forceloads Chunks - Stores Season in Marker
forceload add 0 0
#Forces Toast Message
execute unless entity @e[tag=season_marker] if score #time timeclock matches 20 run say Please set a season by running the following command: /function hh:season_select/

#----------------------------------------------------------------------------------- Seasons - Fall Triggers---------------------------------------------------------------------------------------------------------------------#
##Triggers Halloween Event

execute as @e[type=minecraft:armor_stand,tag=season_marker,scores={seasonSelect=1}] at @s if score #time timeclock matches 13000 run function hh:halloween/selection

#----------------------------------------------------------------------------------- Seasons - Winter Triggers---------------------------------------------------------------------------------------------------------------------#
##Triggers Christmas Event --- CHRISTMAS
execute as @e[type=minecraft:armor_stand,tag=season_marker,scores={seasonSelect=2}] at @s if score #time timeclock matches 13000 run function hh:winter/selection

#----------------------------------------------------------------------------------- Seasons - Spring Triggers---------------------------------------------------------------------------------------------------------------------#
##Triggers Spring Event --- Easter
execute as @e[type=minecraft:armor_stand,tag=season_marker,scores={seasonSelect=3}] at @s if score #time timeclock matches 1 run function hh:spring/selection

#----------------------------------------------------------------------------------- Seasons - Summer Triggers---------------------------------------------------------------------------------------------------------------------#
##Triggers Summer Event --- 


#----------------------------------------------------------------------------------- Timeclock - Events ---------------------------------------------------------------------------------------------------------------------#
#Timeclock function
execute store result score #time timeclock run time query daytime

#Daytime
execute in minecraft:overworld if score #time timeclock matches 1 run tellraw @a {"text":"Morning Crafters! Rise and Shine!","color":"#E68926"}
execute if score #time timeclock matches 1 run function hh:basic_happening/selection_morning
execute if score #time timeclock matches 1 run function hh:mailbox/mail_time
execute in minecraft:overworld at @a[x=0] if score #time timeclock matches 1 run playsound minecraft:time.morning music @a ~ ~ ~ 2
execute as @a[tag=herobrine] if score #time timeclock matches 1 run scoreboard players set @a[] herobrine_timer 1
execute as @a[tag=drop_party] if score #time timeclock matches 2 run scoreboard players set @a[] drop_party_timer 2
##Triggers Christmas Morning - Remove Tags --- CHRISTMAS - KEEP THESE ON FOR THOSE THAT NEED TO UPDATE PACK
execute as @e[tag=santa,type=minecraft:wandering_trader] if score #time timeclock matches 1 run function hh:winter/santa/goodbye
execute as @e[tag=givenPresent,type=minecraft:villager] if score #time timeclock matches 1 run function hh:winter/santa/received_gift
execute as @a[tag=naughtylist] if score #time timeclock matches 1 run tag @a remove naughtylist
execute as @a[tag=presentQuest] if score #time timeclock matches 1 run tag @a remove presentQuest

#Noon
execute if score #time timeclock matches 6000 run function hh:basic_happening/selection
execute if score #time timeclock matches 6000 run function hh:wandering_trader/selection


#Evening
execute in minecraft:overworld if score #time timeclock matches 12500 run tellraw @a {"text":"Night is coming Crafters! ","color":"#9C84BF"}
execute if score #time timeclock matches 12500 run function hh:basic_happening/selection
execute if score #time timeclock matches 13000 run function hh:drop_party/selection
execute if score #time timeclock matches 12500 run function hh:basic_happening/shooting_star/star_chance
#Fall Events
execute as @a[tag=halloween] if score #time timeclock matches 1 run tag @a remove halloween
#Night Music
execute in minecraft:overworld at @a[x=0] if score #time timeclock matches 12500 run playsound minecraft:time.night music @a ~ ~ ~ 2

#Midnight
#execute if score #time timeclock matches 18000 run say Midnight!
execute if score #time timeclock matches 18000 run function hh:basic_happening/selection
execute if score #time timeclock matches 18000 run function hh:basic_happening/shooting_star/star_chance
##Triggers Christmas Event --- CHRISTMAS
execute if score #time timeclock matches 18000 run tp @e[tag=santa,type=minecraft:wandering_trader] @r



#Super-Early-Dawn
execute if score #time timeclock matches 22000 run function hh:basic_happening/shooting_star/star_chance



#----------------------------------------------------------------------------------- H1 - Mailboxes/Mail ---------------------------------------------------------------------------------------------------------------------#

######## Mailbox/package
scoreboard players set @a[nbt={SelectedItem:{id:"minecraft:bat_spawn_egg"}}] mailbox_delay 2

#~~~ Mailbox Place
execute as @e[type=minecraft:armor_stand,tag=mailbox_common] at @s run function hh:mailbox/common/place
execute as @e[type=minecraft:armor_stand,tag=mailbox_rustic] at @s run function hh:mailbox/rustic/place
execute as @e[type=minecraft:armor_stand,tag=mailbox_pink] at @s run function hh:mailbox/pink/place
execute as @e[type=minecraft:armor_stand,tag=mailbox_gold] at @s run function hh:mailbox/gold/place

#~~~ Mailbox Remove
execute as @e[type=minecraft:armor_stand,tag=common_mb] at @s unless block ~ ~ ~ minecraft:dropper run function hh:mailbox/common/remove
execute as @e[type=minecraft:armor_stand,tag=rustic_mb] at @s unless block ~ ~ ~ minecraft:dropper run function hh:mailbox/rustic/remove
execute as @e[type=minecraft:armor_stand,tag=pink_mb] at @s unless block ~ ~ ~ minecraft:dropper run function hh:mailbox/pink/remove
execute as @e[type=minecraft:armor_stand,tag=gold_mb] at @s unless block ~ ~ ~ minecraft:dropper run function hh:mailbox/gold/remove

#~~~ Package Open
######## Package - Placeable armor stand which looks for the nearest placed player.
execute as @e[type=minecraft:armor_stand,tag=package] at @s run function hh:mailbox/package_open

#----------------------------------------------------------------------------------- H2 - Shooting Star ---------------------------------------------------------------------------------------------------------------------#

execute as @e[tag=star,type=minecraft:armor_stand] at @s run function hh:basic_happening/shooting_star/star_falling
execute as @e[tag=star,nbt={OnGround:1b}] at @s run function hh:basic_happening/shooting_star/star_impact

execute as @e[tag=sword_star,type=minecraft:armor_stand] at @s run function hh:starfire/star_falling
execute as @e[tag=sword_star,nbt={OnGround:1b}] at @s run function hh:starfire/star_impact_sword

#Starfire
execute as @a[nbt={SelectedItem:{id:"minecraft:stone_sword",count:1,components:{"minecraft:custom_data":{starfire:1b}}}}] at @s if entity @e[nbt={HurtTime:9s},distance=..6] run function hh:starfire/starfall_chance

execute as @e[scores={star_fall_atk=100}] at @s run function hh:starfire/star_summon
execute as @e[scores={star_fall_atk=80}] at @s run function hh:starfire/star_summon
execute as @e[scores={star_fall_atk=60}] at @s run function hh:starfire/star_summon
execute as @e[scores={star_fall_atk=40}] at @s run function hh:starfire/star_summon
execute as @e[scores={star_fall_atk=20}] at @s run function hh:starfire/star_summon
execute as @e[scores={star_fall_atk=0},tag=stars_fall] at @s run tag @s remove stars_fall

##### Constantly remove 1 from the delay 
execute as @e[scores={star_fall_atk=1..}] at @s run scoreboard players remove @s star_fall_atk 1

#Starfire END##

#----------------------------------------------------------------------------------- H3 - Drop-Party ---------------------------------------------------------------------------------------------------------------------#
##Drop-Star
execute as @e[tag=drop_star,type=minecraft:armor_stand] at @s run function hh:drop_party/drop_star/drop_star_falling
execute as @e[tag=drop_star,nbt={OnGround:1b}] at @s run function hh:drop_party/drop_star/drop_star_impact

#Player Specific
execute as @e[tag=drop_party] at @s run effect give @s minecraft:night_vision 15 1


##Drop-Party
#Executes off Drop-Party tag - First Minute
execute as @a[scores={drop_party_timer=2400}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=2300}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=2200}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=2100}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=2000}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=1980}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=1960}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=1940}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=1900}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=1800}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=1700}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=1600}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=1550}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=1500}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=1400}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=1300}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=1200}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=1100}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=1000}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=980}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=960}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=940}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=900}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=800}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=700}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=600}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=500}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=400}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=300}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=300}] at @s run playsound minecraft:lunar.end ambient @a ~ ~ ~ 100
execute as @a[scores={drop_party_timer=295}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=295}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=290}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=285}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=285}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=280}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=280}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=275}] at @s run function hh:drop_party/drop_star/drop_star_chance
execute as @a[scores={drop_party_timer=270}] at @s run function hh:drop_party/drop_star/drop_star_chance





#Keeps track of "Drop-Party" Tag
execute as @a[scores={drop_party_timer=1..}] at @s run scoreboard players remove @s drop_party_timer 1
execute as @a[scores={drop_party_timer=1}] at @s run weather clear
execute as @a[scores={drop_party_timer=1}] at @s run stopsound @a ambient minecraft:lunar.event
execute as @a[scores={drop_party_timer=..0},tag=drop_party] at @s run tag @s remove drop_party





#----------------------------------------------------------------------------------- H3 - Events ---------------------------------------------------------------------------------------------------------------------#
##Herobrine Event 
#Executes off Herobrine tag
execute as @e[type=#hh:hero_skeleton] at @s if entity @a[tag=herobrine,distance=..40] run effect give @s minecraft:invisibility
execute as @e[type=#hh:hero_bugs] at @s if entity @a[tag=herobrine,distance=..40] run effect give @s minecraft:speed 15 1
execute as @e[type=#hh:hero_zombies,tag=!grudge] at @s if entity @a[tag=herobrine,distance=..40] run effect give @s minecraft:speed 15 1
execute as @e[type=#hh:hero_zombies,tag=!grudge] at @s if entity @a[tag=herobrine,distance=..40] run effect give @s minecraft:strength 15 1
execute as @e[type=minecraft:creeper,tag=!thunder] at @s if entity @a[tag=herobrine,distance=..40] run function hh:basic_happening/herobrine/thunder


#Player Specific
execute as @e[tag=herobrine] at @s run effect give @s minecraft:darkness 15 1
execute as @e[tag=herobrine] at @s run weather thunder

#Keeps track of "Herobrine" Tag
execute as @a[scores={herobrine_timer=1..}] at @s run scoreboard players remove @s herobrine_timer 1
execute as @a[scores={herobrine_timer=..0},tag=herobrine] at @s run effect clear @a minecraft:darkness
execute as @a[scores={herobrine_timer=..0},tag=herobrine] at @s run weather clear 
execute as @a[scores={herobrine_timer=..0},tag=herobrine] at @s run tag @s remove herobrine

##----------------------------------------------------------------------------------- Grudge------------------------------------------------------------------------------>
#Grudge Spawn Options
execute as @e[type=#hh:hero_zombies,tag=!not_grudge] at @s if entity @a[tag=herobrine,distance=..40] run function hh:grudge/grudge_spawn
execute as @e[type=minecraft:creeper,tag=!not_grudge] at @s run function hh:grudge/grudge_spawn_general

#Runs Mob Commands
execute as @e[tag=grudge,type=minecraft:zombie] at @s if entity @a[distance=0..30] run function hh:grudge/mob


##----------------------------------------------------------------------------------- Starmite------------------------------------------------------------------------------>
#Starmite Spawn Options
execute as @e[tag=spawnstarmite,nbt={OnGround:1b}] at @s run function hh:starmite/starmite_spawn_general
execute as @e[type=minecraft:armor_stand,tag=spawnstarmite,tag=summoned] at @s run kill @s

### Armor Stand Rotation for body 
execute as @e[type=minecraft:zombie,tag=starmite] at @s store result entity @e[type=minecraft:armor_stand,tag=starmite_body,limit=1,sort=nearest] Rotation[0] float 1 run data get entity @s Rotation[0]
execute as @e[type=minecraft:armor_stand,tag=starmite_body] at @s unless entity @e[type=minecraft:zombie,tag=starmite,distance=0..4] run kill @s

#Runs Mob Commands
execute as @e[tag=starmite,type=minecraft:zombie] at @s if entity @a[distance=0..30] run function hh:starmite/mob

#Attack Sequence
#Checks for Line of Sight
execute as @e[type=minecraft:zombie,tag=starmite,tag=!los,scores={hh_atk_cool=..6}] at @s if entity @a[distance=..12] run function hh:starmite/los_shot
execute as @e[type=minecraft:zombie,tag=starmite,tag=!los,scores={hh_atk_cool=..5}] at @s if entity @a[distance=..12] run function hh:starmite/los_shot
execute as @e[type=minecraft:zombie,tag=starmite,tag=!los,scores={hh_atk_cool=..4}] at @s if entity @a[distance=..12] run function hh:starmite/los_shot
execute as @e[type=minecraft:zombie,tag=starmite,tag=!los,scores={hh_atk_cool=..3}] at @s if entity @a[distance=..12] run function hh:starmite/los_shot
execute as @e[type=minecraft:zombie,tag=starmite,tag=!los,scores={hh_atk_cool=..2}] at @s if entity @a[distance=..12] run function hh:starmite/los_shot
execute as @e[type=minecraft:zombie,tag=starmite,tag=!los,scores={hh_atk_cool=..1}] at @s if entity @a[distance=..12] run function hh:starmite/los_shot
#Actual Attack - takes the shot 
execute as @e[type=minecraft:zombie,tag=starmite,tag=los] at @s if entity @a[distance=..12] run function hh:starmite/shot
execute as @e[type=minecraft:zombie,tag=starmite,tag=!los,scores={hh_atk_cool=..1}] at @s if entity @a[distance=..12] run scoreboard players set @e[tag=starmite,type=minecraft:zombie,scores={hh_atk_cool=..1}] hh_atk_cool 80


## Activates Cooldown functionality
scoreboard players remove @e[tag=starmite,type=minecraft:zombie,scores={hh_atk_cool=1..}] hh_atk_cool 1


#----------------------------------------------------------------------------------- HALLOWEEN - Functionality ---------------------------------------------------------------------------------------------------------------------#

#Spooky Cat Decor
#~~~ Decor Place
execute as @e[type=minecraft:armor_stand,tag=spooky_cat] at @s run function hh:halloween/spooky_cat/place
#~~~ Decor Remove
execute as @e[type=minecraft:armor_stand,tag=spooky_ct] at @s unless block ~ ~ ~ minecraft:polished_blackstone_button run function hh:halloween/spooky_cat/remove

#Candy Pail 
#~~~ Decor Place
execute as @e[type=minecraft:armor_stand,tag=candy_pail] at @s run function hh:halloween/candy_pail/place
#~~~ Decor Remove
execute as @e[type=minecraft:armor_stand,tag=pail_place] at @s unless block ~ ~ ~ minecraft:polished_blackstone_button run function hh:halloween/candy_pail/remove


#~~~ Box of Candy
######## Package - Placeable armor stand which looks for the nearest placed player.
execute as @e[type=minecraft:armor_stand,tag=candy_box] at @s run function hh:halloween/candy_box_open

#Spooky Cat Spawn Egg
#~~~ Ownership Set
execute as @e[type=minecraft:cat,tag=black_cat,tag=!ownerset] at @s run function hh:halloween/black_cat/spawnegg

#Pumpkin Scythe
execute as @a[nbt={SelectedItem:{id:"minecraft:stone_sword",count:1,components:{"minecraft:custom_data":{pumpkin_scythe:1b}}}}] at @s if entity @e[nbt={HurtTime:10s},distance=..6] run function hh:halloween/scythe

#Pumpkin Scythe END##

#Halloween Spider Spawn - Execute off of spawn egg
execute as @e[type=minecraft:armor_stand,tag=halloween_spider_marker,tag=!summoned] at @s run function hh:halloween/halloween_spider/spawnegg
execute as @e[type=minecraft:armor_stand,tag=halloween_spider_marker,tag=summoned] at @s run kill @s
## Armor Stand Rotation for body 
execute as @e[type=minecraft:wolf,tag=halloween_spider] at @s store result entity @e[type=minecraft:armor_stand,tag=halloween_spider_body,limit=1,sort=nearest] Rotation[0] float 1 run data get entity @s Rotation[0]
execute as @e[type=minecraft:armor_stand,tag=halloween_spider_body] at @s unless entity @e[type=minecraft:wolf,tag=halloween_spider,distance=0..2] run kill @s
## Initializes Halloween Spider Animation/Sound function
execute as @e[type=minecraft:wolf,tag=halloween_spider] at @s if entity @a[distance=0..60] run function hh:halloween/halloween_spider/animate
#Spider Bite
execute as @e[nbt={HurtTime:8s},tag=!halloween_spider,type=!#hh:friendly] at @s if entity @e[type=minecraft:wolf,tag=halloween_spider,distance=..2] run effect give @s[] minecraft:poison 10 1
execute as @e[type=minecraft:wolf,tag=halloween_spider] at @s if entity @e[nbt={HurtTime:8s},tag=!halloween_spider,type=!#hh:friendly,distance=..2] run effect give @s minecraft:regeneration 6 2
execute as @e[type=minecraft:wolf,tag=halloween_spider] at @s if entity @e[nbt={HurtTime:8s},tag=!halloween_spider,type=!#hh:friendly,distance=..2] run effect give @s minecraft:speed 6 0
## Runs Sound File
execute as @e[type=minecraft:wolf,tag=halloween_spider,scores={sounds_cool=0}] at @s if entity @a[distance=0..20] run function hh:halloween/halloween_spider/sounds
## Activates Cooldown functionality
scoreboard players remove @e[tag=halloween_spider,type=minecraft:wolf,scores={sounds_cool=1..},nbt={Sitting:0b}] sounds_cool 1

#Web Staff
execute as @a[scores={staff_w=1..,staff_w_cool=0},nbt={SelectedItem:{id:"minecraft:warped_fungus_on_a_stick",count:1,components:{"minecraft:custom_data":{staffw15:1b}}}}] at @s run function hh:halloween/staff_web/web15
execute as @a[scores={staff_w=1..,staff_w_cool=0},nbt={SelectedItem:{id:"minecraft:warped_fungus_on_a_stick",count:1,components:{"minecraft:custom_data":{staffw14:1b}}}}] at @s run function hh:halloween/staff_web/web14
execute as @a[scores={staff_w=1..,staff_w_cool=0},nbt={SelectedItem:{id:"minecraft:warped_fungus_on_a_stick",count:1,components:{"minecraft:custom_data":{staffw13:1b}}}}] at @s run function hh:halloween/staff_web/web13
execute as @a[scores={staff_w=1..,staff_w_cool=0},nbt={SelectedItem:{id:"minecraft:warped_fungus_on_a_stick",count:1,components:{"minecraft:custom_data":{staffw12:1b}}}}] at @s run function hh:halloween/staff_web/web12
execute as @a[scores={staff_w=1..,staff_w_cool=0},nbt={SelectedItem:{id:"minecraft:warped_fungus_on_a_stick",count:1,components:{"minecraft:custom_data":{staffw11:1b}}}}] at @s run function hh:halloween/staff_web/web11
execute as @a[scores={staff_w=1..,staff_w_cool=0},nbt={SelectedItem:{id:"minecraft:warped_fungus_on_a_stick",count:1,components:{"minecraft:custom_data":{staffw10:1b}}}}] at @s run function hh:halloween/staff_web/web10
execute as @a[scores={staff_w=1..,staff_w_cool=0},nbt={SelectedItem:{id:"minecraft:warped_fungus_on_a_stick",count:1,components:{"minecraft:custom_data":{staffw9:1b}}}}] at @s run function hh:halloween/staff_web/web9
execute as @a[scores={staff_w=1..,staff_w_cool=0},nbt={SelectedItem:{id:"minecraft:warped_fungus_on_a_stick",count:1,components:{"minecraft:custom_data":{staffw8:1b}}}}] at @s run function hh:halloween/staff_web/web8
execute as @a[scores={staff_w=1..,staff_w_cool=0},nbt={SelectedItem:{id:"minecraft:warped_fungus_on_a_stick",count:1,components:{"minecraft:custom_data":{staffw7:1b}}}}] at @s run function hh:halloween/staff_web/web7
execute as @a[scores={staff_w=1..,staff_w_cool=0},nbt={SelectedItem:{id:"minecraft:warped_fungus_on_a_stick",count:1,components:{"minecraft:custom_data":{staffw6:1b}}}}] at @s run function hh:halloween/staff_web/web6
execute as @a[scores={staff_w=1..,staff_w_cool=0},nbt={SelectedItem:{id:"minecraft:warped_fungus_on_a_stick",count:1,components:{"minecraft:custom_data":{staffw5:1b}}}}] at @s run function hh:halloween/staff_web/web5
execute as @a[scores={staff_w=1..,staff_w_cool=0},nbt={SelectedItem:{id:"minecraft:warped_fungus_on_a_stick",count:1,components:{"minecraft:custom_data":{staffw4:1b}}}}] at @s run function hh:halloween/staff_web/web4
execute as @a[scores={staff_w=1..,staff_w_cool=0},nbt={SelectedItem:{id:"minecraft:warped_fungus_on_a_stick",count:1,components:{"minecraft:custom_data":{staffw3:1b}}}}] at @s run function hh:halloween/staff_web/web3
execute as @a[scores={staff_w=1..,staff_w_cool=0},nbt={SelectedItem:{id:"minecraft:warped_fungus_on_a_stick",count:1,components:{"minecraft:custom_data":{staffw2:1b}}}}] at @s run function hh:halloween/staff_web/web2
execute as @a[scores={staff_w=1..,staff_w_cool=0},nbt={SelectedItem:{id:"minecraft:warped_fungus_on_a_stick",count:1,components:{"minecraft:custom_data":{staffw1:1b}}}}] at @s run function hh:halloween/staff_web/web1
###Scoreboards
scoreboard players set @a[scores={staff_w=1..}] staff_w 0
scoreboard players remove @a[scores={staff_w_cool=1..}] staff_w_cool 1 

#Halloween Event - Comment out during Non-Halloween Time
#Witch_Spawn
execute as @e[type=minecraft:witch,tag=!halloween] at @s run function hh:halloween/halloween_event/witch
execute as @e[type=minecraft:spider,tag=!halloween_witch] at @s if entity @a[tag=halloween,distance=..40] run function hh:halloween/halloween_event/witch_chance
execute as @e[type=minecraft:creeper,tag=!halloween_witch] at @s if entity @a[tag=halloween,distance=..40] run function hh:halloween/halloween_event/witch_chance
#Baby Zombie
execute as @e[type=minecraft:zombie,tag=!halloween_zombie,tag=!abomination,tag=!abyssal_horror,tag=!titan,tag=!warpedtitan,tag=!gila,tag=!starmite] at @s if entity @a[tag=halloween,distance=..40] unless entity @e[type=minecraft:armor_stand,tag=manor,distance=..60] unless entity @e[type=minecraft:armor_stand,tag=wealth_alter,distance=..120] unless entity @e[type=minecraft:armor_stand,tag=wrath_alter,distance=..60] run function hh:halloween/halloween_event/baby_zombie
execute as @e[type=minecraft:zombie,tag=halloween_zombie] at @s if entity @a[distance=..2,nbt={SelectedItem:{id:"minecraft:carrot",components:{"minecraft:custom_data":{candy_halloween:1b}}}}] run function hh:halloween/halloween_event/trick_or_treat
#Baby Husk
execute as @e[type=minecraft:husk,tag=!halloween_husk,tag=!spectre,tag=!wraith,tag=!reaper] at @s if entity @a[tag=halloween,distance=..40] run function hh:halloween/halloween_event/baby_husk
execute as @e[type=minecraft:husk,tag=halloween_husk] at @s if entity @a[distance=..2,nbt={SelectedItem:{id:"minecraft:carrot",components:{"minecraft:custom_data":{candy_halloween:1b}}}}] run function hh:halloween/halloween_event/trick_or_treat

#Enderman
execute as @e[type=minecraft:enderman,tag=!halloween_enderman] at @s if entity @a[tag=halloween,distance=..40,nbt={Dimension:"minecraft:overworld"}] run function hh:halloween/halloween_event/enderman
execute as @e[type=minecraft:enderman,tag=halloween_enderman] at @s if entity @a[tag=halloween,distance=..4,nbt={SelectedItem:{id:"minecraft:bat_spawn_egg",components:{"minecraft:custom_data":{candy_pail:1b}}}}] run function hh:halloween/candy_pail/trick_or_treat_enderman
#Iron Golems
execute as @e[type=minecraft:iron_golem,tag=!treated] at @s if entity @a[tag=halloween,distance=..30] run effect give @s[] minecraft:fire_resistance
execute as @e[type=minecraft:iron_golem,tag=!treated] at @s if entity @a[tag=halloween,distance=..4,nbt={SelectedItem:{id:"minecraft:bat_spawn_egg",components:{"minecraft:custom_data":{candy_pail:1b}}}}] run function hh:halloween/candy_pail/trick_or_treat_golem
execute as @e[type=minecraft:iron_golem,tag=treated] if score #time timeclock matches 1 run tag @s remove treated

#----------------------------------------------------------------------------------- Zombie Armor ---------------------------------------------------------------------------------------------------------------------#

#Zombie-Armor - 
execute as @a[tag=!zomb_cap,nbt={equipment:{head:{id:'minecraft:carved_pumpkin',components:{"minecraft:custom_data":{zomb:1b}}}}}] at @s run tag @s add zomb_cap
execute as @a[tag=!zomb_chest,nbt={equipment:{chest:{id:'minecraft:leather_chestplate',components:{"minecraft:custom_data":{zomb:1b}}}}}] at @s run tag @s add zomb_chest
execute as @a[tag=!zomb_legs,nbt={equipment:{legs:{id:'minecraft:leather_leggings',components:{"minecraft:custom_data":{zomb:1b}}}}}] at @s run tag @s add zomb_legs
execute as @a[tag=!zomb_boots,nbt={equipment:{feet:{id:'minecraft:leather_boots',components:{"minecraft:custom_data":{zomb:1b}}}}}] at @s run tag @s add zomb_boots

#Applying Saturation
execute as @a[tag=zomb_cap,nbt={HurtTime:9s}] at @s run effect give @s minecraft:saturation 1 0
execute as @a[tag=zomb_chest,nbt={HurtTime:9s}] at @s run effect give @s minecraft:saturation 1 0
execute as @a[tag=zomb_legs,nbt={HurtTime:9s}] at @s run effect give @s minecraft:saturation 1 0
execute as @a[tag=zomb_boots,nbt={HurtTime:9s}] at @s run effect give @s minecraft:saturation 1 0

#Zombie Armor 
execute as @a[tag=zomb_cap] at @s unless entity @s[nbt={equipment:{head:{id:'minecraft:carved_pumpkin',components:{"minecraft:custom_data":{zomb:1b}}}}}] at @s run tag @s remove zomb_cap
execute as @a[tag=zomb_chest] at @s unless entity @s[nbt={equipment:{chest:{id:'minecraft:leather_chestplate',components:{"minecraft:custom_data":{zomb:1b}}}}}] at @s run tag @s remove zomb_chest
execute as @a[tag=zomb_legs] at @s unless entity @s[nbt={equipment:{legs:{id:'minecraft:leather_leggings',components:{"minecraft:custom_data":{zomb:1b}}}}}] at @s run tag @s remove zomb_legs
execute as @a[tag=zomb_boots] at @s unless entity @s[nbt={equipment:{feet:{id:'minecraft:leather_boots',components:{"minecraft:custom_data":{zomb:1b}}}}}] at @s run tag @s remove zomb_boots

#----------------------------------------------------------------------------------- Witch - Armor ---------------------------------------------------------------------------------------------------------------------#

#Witch-Armor - 
execute as @a[tag=!witch_cap,nbt={equipment:{head:{id:'minecraft:carved_pumpkin',components:{"minecraft:custom_data":{witch:1b}}}}}] at @s run tag @s add witch_cap
execute as @a[tag=!witch_chest,nbt={equipment:{chest:{id:'minecraft:leather_chestplate',components:{"minecraft:custom_data":{witch:1b}}}}}] at @s run tag @s add witch_chest
execute as @a[tag=!witch_legs,nbt={equipment:{legs:{id:'minecraft:leather_leggings',components:{"minecraft:custom_data":{witch:1b}}}}}] at @s run tag @s add witch_legs
execute as @a[tag=!witch_boots,nbt={equipment:{feet:{id:'minecraft:leather_boots',components:{"minecraft:custom_data":{witch:1b}}}}}] at @s run tag @s add witch_boots

#Applying Saturation
execute as @a[tag=witch_cap,nbt={HurtTime:9s}] at @s run function hh:halloween/witch_armor
execute as @a[tag=witch_chest,nbt={HurtTime:9s}] at @s run function hh:halloween/witch_armor
execute as @a[tag=witch_legs,nbt={HurtTime:9s}] at @s run function hh:halloween/witch_armor
execute as @a[tag=witch_boots,nbt={HurtTime:9s}] at @s run function hh:halloween/witch_armor

#Witch Armor 
execute as @a[tag=witch_cap] at @s unless entity @s[nbt={equipment:{head:{id:'minecraft:carved_pumpkin',components:{"minecraft:custom_data":{witch:1b}}}}}] at @s run tag @s remove witch_cap
execute as @a[tag=witch_chest] at @s unless entity @s[nbt={equipment:{chest:{id:'minecraft:leather_chestplate',components:{"minecraft:custom_data":{witch:1b}}}}}] at @s run tag @s remove witch_chest
execute as @a[tag=witch_legs] at @s unless entity @s[nbt={equipment:{legs:{id:'minecraft:leather_leggings',components:{"minecraft:custom_data":{witch:1b}}}}}] at @s run tag @s remove witch_legs
execute as @a[tag=witch_boots] at @s unless entity @s[nbt={equipment:{feet:{id:'minecraft:leather_boots',components:{"minecraft:custom_data":{witch:1b}}}}}] at @s run tag @s remove witch_boots




##----------------------------------------------------------------------------------- WINTER - Functionality ---------------------------------------------------------------------------------------------------------------------#
#Stocking Decor
#~~~ Decor Place
execute as @e[type=minecraft:armor_stand,tag=stocking] at @s run function hh:winter/stocking/place
#~~~ Decor Remove
execute as @e[type=minecraft:armor_stand,tag=stocking_hung] at @s unless block ~ ~ ~ minecraft:polished_blackstone_button run function hh:winter/stocking/remove
#~~~ Stocking Stuffer 
execute as @e[type=minecraft:armor_stand,tag=stocking_hung,tag=stuffed] at @s if block ~ ~ ~ minecraft:polished_blackstone_button[powered=true] run function hh:winter/stocking/stuffer

#Christmas Caper
execute as @a[nbt={SelectedItem:{id:"minecraft:stone_sword",count:1,components:{"minecraft:custom_data":{caper:1b}}}}] at @s if entity @e[nbt={HurtTime:9s},distance=..6] run function hh:winter/caper
#Christmas Caper END##

#Christmas Tree
#~~~ Decor Place
execute as @e[type=minecraft:armor_stand,tag=christmas_tree] at @s run function hh:winter/christmas_tree/place
#~~~ Decor Remove
execute as @e[type=minecraft:armor_stand,tag=christmas_tree_placed] at @s unless block ~ ~ ~ minecraft:lantern run function hh:winter/christmas_tree/remove

#Wreath
#~~~ Decor Place
execute as @e[type=minecraft:armor_stand,tag=wreath] at @s run function hh:winter/wreath/place
#~~~ Decor Remove
execute as @e[type=minecraft:armor_stand,tag=wreath_hung] at @s unless block ~ ~ ~ minecraft:polished_blackstone_button run function hh:winter/wreath/remove

##Santa Spawn - 
### Armor Stand Rotation for body 
execute as @e[type=minecraft:wandering_trader,tag=santa] at @s store result entity @e[type=minecraft:armor_stand,tag=santa_body,limit=1,sort=nearest] Rotation[0] float 1 run data get entity @s Rotation[0]
execute as @e[type=minecraft:armor_stand,tag=santa_body] at @s unless entity @e[type=minecraft:wandering_trader,tag=santa,distance=0..2] run kill @s
### Initializes Santa Animation/Sound function
execute as @e[type=minecraft:wandering_trader,tag=santa] at @s if entity @a[distance=0..60] run function hh:winter/santa/animate
#### Runs Sound File
execute as @e[type=minecraft:wandering_trader,tag=santa,scores={sounds_cool=0}] at @s if entity @a[distance=0..20] run function hh:winter/santa/sounds
#### Activates Cooldown functionality
scoreboard players remove @e[tag=santa,type=minecraft:wandering_trader,scores={sounds_cool=1..}] sounds_cool 1
###Halloween Spider 1.20.2 - Invisible Potion Effect
#execute as @e[type=minecraft:wandering_trader,tag=santa] at @s run effect give @s minecraft:invisibility
#
#CHRISTMAS QUEST
execute as @a[tag=!presentQuest,tag=!naughtylist] at @s if entity @e[tag=santa,distance=..4,type=minecraft:wandering_trader] run function hh:winter/santa/villager_quest
#Delivering Presents to villagers
execute as @e[type=minecraft:villager,tag=!givenPresent] at @s if entity @a[distance=..2,nbt={SelectedItem:{id:"minecraft:bat_spawn_egg",components:{"minecraft:custom_data":{package_villager:1b}}}}] run function hh:winter/santa/present_delivery
#Happy Villagers Christmas Morning
execute as @e[type=minecraft:villager,tag=readytogive] at @s if entity @a[distance=..2] run function hh:winter/santa/ready_to_give


#~~~ Villager Package Open
######## Package - Placeable armor stand which looks for the nearest placed player.
execute as @e[type=minecraft:armor_stand,tag=package_villager] at @s run function hh:winter/package_open

#----------------------------------------------------------------------------------- Santa/Elf Armor ---------------------------------------------------------------------------------------------------------------------#

#Santa-Armor - 
execute as @a[tag=!santa_cap,nbt={equipment:{head:{id:'minecraft:carved_pumpkin',components:{"minecraft:custom_data":{santa:1b}}}}}] at @s run tag @s add santa_cap
execute as @a[tag=!santa_chest,nbt={equipment:{chest:{id:'minecraft:leather_chestplate',components:{"minecraft:custom_data":{santa:1b}}}}}] at @s run tag @s add santa_chest
execute as @a[tag=!santa_legs,nbt={equipment:{legs:{id:'minecraft:leather_leggings',components:{"minecraft:custom_data":{santa:1b}}}}}] at @s run tag @s add santa_legs
execute as @a[tag=!santa_legs_elf,nbt={equipment:{legs:{id:'minecraft:golden_leggings',components:{"minecraft:custom_data":{santa:1b}}}}}] at @s run tag @s add santa_legs_elf
execute as @a[tag=!santa_boots,nbt={equipment:{feet:{id:'minecraft:leather_boots',components:{"minecraft:custom_data":{santa:1b}}}}}] at @s run tag @s add santa_boots

#Giving Gift
execute as @a[tag=santa_cap] at @s if score #time timeclock matches 1 run function hh:winter/armor/gift_chance
execute as @a[tag=santa_chest] at @s if score #time timeclock matches 1 run function hh:winter/armor/gift_chance
execute as @a[tag=santa_legs] at @s if score #time timeclock matches 1 run function hh:winter/armor/gift_chance
execute as @a[tag=santa_legs_elf] at @s if score #time timeclock matches 1 run function hh:winter/armor/gift_chance
execute as @a[tag=santa_boots] at @s if score #time timeclock matches 1 run function hh:winter/armor/gift_chance

#Santa-Armor 
execute as @a[tag=santa_cap] at @s unless entity @s[nbt={equipment:{head:{id:'minecraft:carved_pumpkin',components:{"minecraft:custom_data":{santa:1b}}}}}] at @s run tag @s remove santa_cap
execute as @a[tag=santa_chest] at @s unless entity @s[nbt={equipment:{chest:{id:'minecraft:leather_chestplate',components:{"minecraft:custom_data":{santa:1b}}}}}] at @s run tag @s remove santa_chest
execute as @a[tag=santa_legs] at @s unless entity @s[nbt={equipment:{legs:{id:'minecraft:leather_leggings',components:{"minecraft:custom_data":{santa:1b}}}}}] at @s run tag @s remove santa_legs
execute as @a[tag=santa_legs_elf] at @s unless entity @s[nbt={equipment:{legs:{id:'minecraft:golden_leggings',components:{"minecraft:custom_data":{santa:1b}}}}}] at @s run tag @s remove santa_legs_elf
execute as @a[tag=santa_boots] at @s unless entity @s[nbt={equipment:{feet:{id:'minecraft:leather_boots',components:{"minecraft:custom_data":{santa:1b}}}}}] at @s run tag @s remove santa_boots



#----------------------------------------------------------------------------------- SPRING - Functionality ---------------------------------------------------------------------------------------------------------------------#

######## Easter Egg - Placeable armor stand which looks for the nearest placed player.
execute as @e[type=minecraft:armor_stand,tag=easter_egg] at @s run function hh:spring/package_open

#Easter Egg Summon
execute as @e[tag=eggie,type=minecraft:armor_stand] at @s run function hh:spring/easter_event/dropping_egg/star_falling
execute as @e[tag=eggie,nbt={OnGround:1b}] at @s run function hh:spring/easter_event/dropping_egg/star_impact

#Easter Basket Decor
#~~~ Decor Place
execute as @e[type=minecraft:armor_stand,tag=bunny_basket] at @s run function hh:spring/bunny_basket/place
#~~~ Decor Remove
execute as @e[type=minecraft:armor_stand,tag=basket] at @s unless block ~ ~ ~ minecraft:polished_blackstone_button run function hh:spring/bunny_basket/remove
#~~~ Stocking Stuffer 
execute as @e[type=minecraft:armor_stand,tag=basket,tag=stuffed] at @s if block ~ ~ ~ minecraft:polished_blackstone_button[powered=true] run function hh:spring/bunny_basket/stuffer

#~~~ Artist Bundle
######## Package - Placeable armor stand which looks for the nearest placed player.
execute as @e[type=minecraft:armor_stand,tag=artist_bundle] at @s run function hh:spring/artist_bundle

#~~~ Decor Place - Pot-o-gold
execute as @e[type=minecraft:armor_stand,tag=pot_o_gold] at @s run function hh:spring/pot_o_gold/place
#~~~ Decor Remove - Pot-o-gold
execute as @e[type=minecraft:armor_stand,tag=pot_o_gold_placed] at @s unless block ~ ~ ~ minecraft:lantern run function hh:spring/pot_o_gold/remove

#~~~ Decor Place - Pot-o-gold
execute as @e[type=minecraft:armor_stand,tag=decorative_eggs] at @s run function hh:spring/decorative_eggs/place
#~~~ Decor Remove - Pot-o-gold
execute as @e[type=minecraft:armor_stand,tag=eggs_decor_placed] at @s unless block ~ ~ ~ minecraft:polished_blackstone_button run function hh:spring/decorative_eggs/remove

#----------------------------------------------------------------------------------- Lucky Hat/Bunny Hat ---------------------------------------------------------------------------------------------------------------------#
#Armor - Setting Tome Reuse Tag
execute as @a[tag=!lucky_hat,nbt={equipment:{head:{id:'minecraft:carved_pumpkin',components:{"minecraft:custom_data":{leprechaun_hat:1b}}}}}] at @s run tag @s add lucky_hat
execute as @a[tag=!bunny_hops,nbt={equipment:{head:{id:'minecraft:carved_pumpkin',components:{"minecraft:custom_data":{bunny_ears:1b}}}}}] at @s run tag @s add bunny_hops


#If Pieces are worn - execute off of pieces that are worn
execute if score #time timeclock matches 1 run function hh:spring/lucky_hat/luck
execute if score #time timeclock matches 6000 run function hh:spring/lucky_hat/luck
execute if score #time timeclock matches 12500 run function hh:spring/lucky_hat/luck
execute if score #time timeclock matches 18000 run function hh:spring/lucky_hat/luck

#Armor - Removing Tags
execute as @a[tag=lucky_hat] at @s unless entity @s[nbt={equipment:{head:{id:'minecraft:carved_pumpkin',components:{"minecraft:custom_data":{leprechaun_hat:1b}}}}}] at @s run tag @s remove lucky_hat

#Lady Luck
execute as @a[scores={lady_luck=..0},nbt={SelectedItem:{id:"minecraft:stone_sword",count:1,components:{"minecraft:custom_data":{lady_luck:1b}}}}] at @s run function hh:spring/lady_luck/lady_luck_chance
execute as @e[tag=lady_luck_treasure,tag=!lady_luck_treasure_countdown] at @s run function hh:spring/lady_luck/lady_luck_treasure_countdown
execute as @e[tag=lady_luck_treasure] at @s run particle minecraft:happy_villager ~ ~ ~ 0.1 1 0.1 .1 5 
execute as @e[tag=lady_luck_treasure] at @s run particle minecraft:totem_of_undying ~ ~ ~ 0.1 1 0.1 .1 5 
execute as @e[tag=lady_luck_treasure,nbt={HurtTime:9s}] at @s run loot spawn ~ ~ ~ loot hh:entities/spring/lady_luck

execute as @e[scores={lady_luck_goldmine=100}] at @s run playsound minecraft:block.note_block.bell ambient @a ~ ~ ~ 2
execute as @e[scores={lady_luck_goldmine=80}] at @s run playsound minecraft:block.note_block.bell ambient @a ~ ~ ~ 2
execute as @e[scores={lady_luck_goldmine=60}] at @s run playsound minecraft:block.note_block.bell ambient @a ~ ~ ~ 2
execute as @e[scores={lady_luck_goldmine=40}] at @s run playsound minecraft:block.note_block.bell ambient @a ~ ~ ~ 2
execute as @e[scores={lady_luck_goldmine=20}] at @s run playsound minecraft:block.note_block.bell ambient @a ~ ~ ~ 2
execute as @e[scores={lady_luck_goldmine=0},tag=lady_luck_treasure_countdown] at @s run function hh:spring/lady_luck/lady_luck_removal
#Lady Luck END##

#Mighty Carrot
execute as @a[nbt={SelectedItem:{id:"minecraft:stone_sword",count:1,components:{"minecraft:custom_data":{mighty_carrot:1b}}}}] at @s if entity @e[nbt={HurtTime:9s},distance=..6] run function hh:spring/mighty_carrot/loot
#Mighty Carrot END##

#### Constantly remove 1 from the delay 
execute as @a[scores={lady_luck=1..}] unless entity @s[nbt={SelectedItem:{id:"minecraft:stone_sword"},tag:{lady_luck:1b}}] run scoreboard players remove @s lady_luck 1
execute as @e[scores={lady_luck_goldmine=1..}] at @s run scoreboard players remove @s lady_luck_goldmine 1


#--- Kadburi Weapon------------------------------------------------------------------------------------->
#Reload Weapon
execute as @a[scores={kadburiirld=1..},nbt={SelectedItem:{id:"minecraft:warped_fungus_on_a_stick",count:1,components:{"minecraft:custom_data":{kadburii:1b}}},Inventory:[{id:"minecraft:carrot",components:{"minecraft:custom_data":{chocolate_egg:1b}}}]}] at @s run function hh:kadburii/reload
execute as @a[scores={kadburii_cool=..1},nbt={SelectedItem:{id:"minecraft:warped_fungus_on_a_stick",count:1,components:{"minecraft:custom_data":{kadburii:1b}}},Inventory:[{id:"minecraft:carrot",components:{"minecraft:custom_data":{chocolate_egg:1b}}}]}] at @s run function hh:kadburii/steady_weapon

#Racked Round
execute as @a[scores={kadburii=13..},nbt={SelectedItem:{id:"minecraft:warped_fungus_on_a_stick",count:1,components:{"minecraft:custom_data":{kadburii:1b}}},Inventory:[{id:"minecraft:carrot",components:{"minecraft:custom_data":{chocolate_egg:1b}}}]}] at @s run function hh:kadburii/rack_round


##Ready to Fire!
execute as @a[scores={kadburiiracking=0,kadburiirld=1..},nbt={SelectedItem:{id:"minecraft:warped_fungus_on_a_stick",count:1,components:{"minecraft:custom_data":{kadburiiloaded:1b}}}}] at @s run function hh:kadburii/shot

#Multi-Enemy Dmg
execute as @e[tag=kad_shot] at @s run function hh:kadburii/dmg

#Reload Scoreboards for Animation, plus steadies weapon when not reloading.
#Keeps setting the score to 1 when player fires the Bonesketrld (THIS CODE NEEDS TO BE BELOW COMMANDS AT THE BOTTOM!)
scoreboard players set @a[scores={kadburiirld=1..}] kadburiirld 0
scoreboard players remove @a[scores={kadburii_cool=1..}] kadburii_cool 1
scoreboard players remove @a[scores={kadburiiready=1..}] kadburiiready 1
#How long until the round is racked, once it hits ten the round is racked and the countdown resets.
scoreboard players set @a[scores={kadburii=13..}] kadburii 0
#Sets rackround cooldown, so round doesn't immediately fire.
scoreboard players remove @a[scores={kadburiiracking=1..}] kadburiiracking 1
#Kadburi END#

#----------------------------------------------------------------------------------- ALL BAT SPAWN EGG EXECUTION/PLACEABLE OBJECTS ---------------------------------------------------------------------------------------------------------------------#

#### Constantly remove 1 from the delay 
execute as @a[scores={mailbox_delay=1..}] unless entity @s[nbt={SelectedItem:{id:"minecraft:bat_spawn_egg"}}] run scoreboard players remove @s mailbox_delay 1
##### Reset eat scoreboard - All Types
scoreboard players reset @a[scores={mailbox_place=1..}] mailbox_place

