/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappaessentials;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import java.nio.file.Path;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.kappasmp.kappaessentials.bounty.BountyCommand;
import net.kappasmp.kappaessentials.bounty.BountyManager;
import net.kappasmp.kappaessentials.command.AfkCommand;
import net.kappasmp.kappaessentials.command.BalTopCommand;
import net.kappasmp.kappaessentials.command.ReloadCommand;
import net.kappasmp.kappaessentials.config.ConfigManager;
import net.kappasmp.kappaessentials.economy.BalCommand;
import net.kappasmp.kappaessentials.economy.BalanceManager;
import net.kappasmp.kappaessentials.economy.PayCommand;
import net.kappasmp.kappaessentials.economy.SellCommand;
import net.kappasmp.kappaessentials.gui.ShopGui;
import net.kappasmp.kappaessentials.homes.HomeCommand;
import net.kappasmp.kappaessentials.homes.HomeManager;
import net.kappasmp.kappaessentials.manager.ShopManager;
import net.kappasmp.kappaessentials.teleport.HomeTeleportScheduler;
import net.kappasmp.kappaessentials.teleport.TpAcceptCommand;
import net.kappasmp.kappaessentials.teleport.TpDenyCommand;
import net.kappasmp.kappaessentials.teleport.TpaCommand;
import net.kappasmp.kappaessentials.teleport.TpahereCommand;
import net.kappasmp.kappaessentials.token.TokenManager;
import net.kappasmp.kappaessentials.token.TokenTopCommand;
import net.kappasmp.kappaessentials.token.TokensCommand;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.command.CommandManager;
import net.minecraft.server.command.ServerCommandSource;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.text.Text;
import net.minecraft.util.Identifier;

public class KappaEssentials
implements ModInitializer {
    public static final String MOD_ID = "kappaessentials";
    private static MinecraftServer serverInstance;

    public void onInitialize() {
        this.registerCommands();
        ServerLifecycleEvents.SERVER_STARTED.register(this::onServerStart);
        ServerLifecycleEvents.SERVER_STOPPING.register(this::onServerStop);
        KappaEssentials.log("Mod initialized.");
        BountyManager.loadBounties();
        HomeManager.loadHomes();
        ServerTickEvents.END_SERVER_TICK.register(HomeTeleportScheduler::tick);
        ConfigManager.init(FabricLoader.getInstance().getConfigDir());
        System.out.println("[KappaEssentials] Initialized with config:");
        System.out.println(ConfigManager.getHomeConfig());
    }

    private void registerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            BalCommand.register((CommandDispatcher<ServerCommandSource>)dispatcher);
            SellCommand.register((CommandDispatcher<ServerCommandSource>)dispatcher);
            ReloadCommand.register((CommandDispatcher<ServerCommandSource>)dispatcher);
            AfkCommand.register((CommandDispatcher<ServerCommandSource>)dispatcher);
            TokensCommand.register((CommandDispatcher<ServerCommandSource>)dispatcher);
            TokenTopCommand.register((CommandDispatcher<ServerCommandSource>)dispatcher);
            BalTopCommand.register((CommandDispatcher<ServerCommandSource>)dispatcher);
            PayCommand.register((CommandDispatcher<ServerCommandSource>)dispatcher);
            BountyCommand.register((CommandDispatcher<ServerCommandSource>)dispatcher);
            HomeCommand.register((CommandDispatcher<ServerCommandSource>)dispatcher);
            TpaCommand.register((CommandDispatcher<ServerCommandSource>)dispatcher);
            TpahereCommand.register((CommandDispatcher<ServerCommandSource>)dispatcher);
            TpAcceptCommand.register((CommandDispatcher<ServerCommandSource>)dispatcher);
            TpDenyCommand.register((CommandDispatcher<ServerCommandSource>)dispatcher);
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)CommandManager.literal((String)"shop").requires(source -> source.hasPermissionLevel(0))).executes(context -> {
                ServerPlayerEntity player = ((ServerCommandSource)context.getSource()).getPlayer();
                new ShopGui(player).open();
                return 1;
            }));
        });
    }

    private void onServerStart(MinecraftServer server) {
        serverInstance = server;
        Path configDir = FabricLoader.getInstance().getConfigDir();
        BalanceManager.init(server);
        TokenManager.load();
        ShopManager.init(configDir);
        this.registerPlaceholders();
        KappaEssentials.log("Balances, tokens, and shop loaded.");
    }

    private void onServerStop(MinecraftServer server) {
        BalanceManager.saveBalances();
        TokenManager.save();
        ShopManager.saveShop();
        KappaEssentials.log("Balances, tokens, and shop saved.");
    }

    public static MinecraftServer getServerInstance() {
        return serverInstance;
    }

    public static void onPlayerLeave(ServerPlayerEntity player) {
        BalanceManager.savePlayerBalance(player);
    }

    public static void log(String message) {
        System.out.println("[kappaessentials] " + message);
    }

    private void registerPlaceholders() {
        Placeholders.register((Identifier)Identifier.of((String)MOD_ID, (String)"bal"), this::balancePlaceholder);
        Placeholders.register((Identifier)Identifier.of((String)MOD_ID, (String)"tokens"), this::tokensPlaceholder);
    }

    private PlaceholderResult balancePlaceholder(PlaceholderContext ctx, String arg) {
        if (!ctx.hasPlayer()) {
            return PlaceholderResult.invalid((String)"No player context");
        }
        double balance = BalanceManager.getBalance(ctx.player().getUuid());
        return PlaceholderResult.value((Text)Text.literal((String)this.formatBalance(balance)));
    }

    private PlaceholderResult tokensPlaceholder(PlaceholderContext ctx, String arg) {
        if (!ctx.hasPlayer()) {
            return PlaceholderResult.invalid((String)"No player context");
        }
        UUID playerUUID = ctx.player().getUuid();
        int tokens = TokenManager.getTokens(playerUUID);
        return PlaceholderResult.value((Text)Text.literal((String)this.formatTokens(tokens)));
    }

    private String formatBalance(double balance) {
        if (balance >= 1.0E9) {
            return String.format("%.2fB", balance / 1.0E9);
        }
        if (balance >= 1000000.0) {
            return String.format("%.2fM", balance / 1000000.0);
        }
        if (balance >= 1000.0) {
            return String.format("%.2fK", balance / 1000.0);
        }
        return String.format("%.2f", balance);
    }

    private String formatTokens(int tokens) {
        double value = tokens;
        if (value >= 1.0E9) {
            return String.format("%.2fb", value / 1.0E9);
        }
        if (value >= 1000000.0) {
            return String.format("%.2fm", value / 1000000.0);
        }
        if (value >= 1000.0) {
            return String.format("%.2fk", value / 1000.0);
        }
        return String.format("%.2f", value);
    }
}

