/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappaessentials.bounty;

import net.fabricmc.fabric.api.entity.event.v1.ServerEntityCombatEvents;
import net.kappasmp.kappaessentials.bounty.BountyManager;
import net.kappasmp.kappaessentials.economy.BalanceManager;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.text.Text;

public class BountyRewardHandler {
    public static String formatMoney(int amount) {
        if (amount >= 1000000000) {
            return amount / 1000000000 + "B";
        }
        if (amount >= 1000000) {
            return amount / 1000000 + "M";
        }
        if (amount >= 1000) {
            return amount / 1000 + "K";
        }
        return String.valueOf(amount);
    }

    public static void register() {
        ServerEntityCombatEvents.AFTER_KILLED_OTHER_ENTITY.register((world, entity, killedEntity) -> {
            if (!(entity instanceof ServerPlayerEntity)) {
                return;
            }
            ServerPlayerEntity killer = (ServerPlayerEntity)entity;
            if (!(killedEntity instanceof ServerPlayerEntity)) {
                return;
            }
            ServerPlayerEntity victim = (ServerPlayerEntity)killedEntity;
            int bounty = BountyManager.getBounty(victim.getUuid());
            if (bounty <= 0) {
                return;
            }
            String formattedBounty = BountyRewardHandler.formatMoney(bounty);
            BalanceManager.addBalance(killer.getUuid(), bounty);
            killer.sendMessage((Text)Text.literal((String)("\u00a7aYou claimed a bounty of \u00a7c$" + formattedBounty + " \u00a7afor killing \u00a7e" + victim.getName().getString())), false);
            victim.sendMessage((Text)Text.literal((String)("\u00a7cYou were killed by \u00a7e" + killer.getName().getString() + "\u00a7c and your bounty of \u00a7c$" + formattedBounty + " \u00a7cwas claimed.")), false);
            BalanceManager.subtractBalance(victim.getUuid(), bounty);
            BountyManager.removeBounty(victim.getUuid());
            BountyManager.saveBounties();
        });
    }
}

