/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappaessentials.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import net.kappasmp.kappaessentials.token.TokenManager;
import net.minecraft.server.command.CommandManager;
import net.minecraft.server.command.ServerCommandSource;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.text.Text;
import net.minecraft.util.math.BlockPos;

public class AfkCommand {
    private static final Map<UUID, Long> afkStartTimes = new HashMap<UUID, Long>();
    private static final Map<UUID, BlockPos> afkStartPositions = new HashMap<UUID, BlockPos>();
    private static final Map<UUID, Timer> afkTimers = new HashMap<UUID, Timer>();

    public static void register(CommandDispatcher<ServerCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)CommandManager.literal((String)"afk").executes(context -> {
            final ServerPlayerEntity player = ((ServerCommandSource)context.getSource()).getPlayer();
            final UUID uuid = player.getUuid();
            if (afkTimers.containsKey(uuid)) {
                player.sendMessage((Text)Text.literal((String)"\u00a7cYou're already AFK! Use \u00a7e/afk stop \u00a7cto cancel it."), false);
                return 0;
            }
            BlockPos startPos = player.getBlockPos();
            afkStartTimes.put(uuid, System.currentTimeMillis());
            afkStartPositions.put(uuid, startPos);
            player.sendMessage((Text)Text.literal((String)"\u00a76You are now AFK. \u00a77Stay still for \u00a761 minute\u00a77 to earn a token."), false);
            Timer timer = new Timer();
            afkTimers.put(uuid, timer);
            timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    BlockPos originalPos;
                    ServerPlayerEntity stillPlayer = player.getServer().getPlayerManager().getPlayer(uuid);
                    if (stillPlayer == null) {
                        return;
                    }
                    BlockPos currentPos = stillPlayer.getBlockPos();
                    if (currentPos.equals((Object)(originalPos = afkStartPositions.get(uuid)))) {
                        TokenManager.giveTokens(uuid, 1);
                        stillPlayer.sendMessage((Text)Text.literal((String)"\u00a76+1 Token! \u00a77Thanks for being AFK."), false);
                    } else {
                        stillPlayer.sendMessage((Text)Text.literal((String)"\u00a7cYou moved! \u00a77No token for you."), false);
                        AfkCommand.cancelAfk(uuid);
                    }
                }
            }, 60000L, 60000L);
            return 1;
        })).then(CommandManager.literal((String)"stop").executes(context -> {
            ServerPlayerEntity player = ((ServerCommandSource)context.getSource()).getPlayer();
            UUID uuid = player.getUuid();
            if (!afkTimers.containsKey(uuid)) {
                player.sendMessage((Text)Text.literal((String)"\u00a7cYou're not AFK right now."), false);
                return 0;
            }
            AfkCommand.cancelAfk(uuid);
            player.sendMessage((Text)Text.literal((String)"\u00a77You are no longer AFK."), false);
            return 1;
        })));
    }

    private static void cancelAfk(UUID uuid) {
        Timer timer = afkTimers.remove(uuid);
        if (timer != null) {
            timer.cancel();
        }
        afkStartTimes.remove(uuid);
        afkStartPositions.remove(uuid);
    }
}

