/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappaessentials.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.kappasmp.kappaessentials.economy.BalanceManager;
import net.minecraft.server.command.ServerCommandSource;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.text.Text;

public class BalTopCommand {
    public static void register(CommandDispatcher<ServerCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"baltop").requires(source -> source.hasPermissionLevel(0))).executes(context -> BalTopCommand.execute((ServerCommandSource)context.getSource())));
    }

    private static int execute(ServerCommandSource source) {
        List<Map.Entry<UUID, Integer>> topBalances = BalanceManager.getTopBalances(10);
        source.sendMessage((Text)Text.literal((String)"\u00a76\u00a7lTop 10 Balances:"));
        int rank = 1;
        for (Map.Entry<UUID, Integer> entry : topBalances) {
            String name = BalTopCommand.getPlayerName(source, entry.getKey());
            String formatted = BalTopCommand.formatBalance(entry.getValue());
            source.sendMessage((Text)Text.literal((String)("\u00a76\u00a7l" + rank + ". \u00a77" + name + " - $" + formatted)));
            ++rank;
        }
        return 1;
    }

    private static String formatBalance(int balance) {
        double value = balance;
        if (value >= 1.0E9) {
            return String.format("%.2fb", value / 1.0E9);
        }
        if (value >= 1000000.0) {
            return String.format("%.2fm", value / 1000000.0);
        }
        if (value >= 1000.0) {
            return String.format("%.2fk", value / 1000.0);
        }
        return String.format("%.2f", value);
    }

    private static String getPlayerName(ServerCommandSource source, UUID uuid) {
        ServerPlayerEntity player = source.getServer().getPlayerManager().getPlayer(uuid);
        if (player != null) {
            return player.getName().getString();
        }
        Optional profile = source.getServer().getUserCache().getByUuid(uuid);
        return profile.map(GameProfile::getName).orElse(uuid.toString().substring(0, 8));
    }
}

