/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappaessentials.economy;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import java.util.UUID;
import net.kappasmp.kappaessentials.economy.BalanceManager;
import net.minecraft.server.command.CommandManager;
import net.minecraft.server.command.ServerCommandSource;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.text.MutableText;
import net.minecraft.text.Style;
import net.minecraft.text.Text;

public class BalCommand {
    public static void register(CommandDispatcher<ServerCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)CommandManager.literal((String)"bal").executes(context -> {
            ServerCommandSource source = (ServerCommandSource)context.getSource();
            return BalCommand.showBalance(source, source.getPlayer().getUuid(), source.getName());
        })).then(CommandManager.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String playerName = StringArgumentType.getString((CommandContext)context, (String)"player");
            ServerCommandSource source = (ServerCommandSource)context.getSource();
            ServerPlayerEntity onlinePlayer = source.getServer().getPlayerManager().getPlayer(playerName);
            if (onlinePlayer != null) {
                return BalCommand.showBalance(source, onlinePlayer.getUuid(), onlinePlayer.getName().getString());
            }
            Optional profile = source.getServer().getUserCache().findByName(playerName);
            if (profile.isPresent()) {
                UUID uuid = ((GameProfile)profile.get()).getId();
                return BalCommand.showBalance(source, uuid, playerName);
            }
            source.sendFeedback(() -> Text.literal((String)"Player not found."), false);
            return 0;
        })));
    }

    private static int showBalance(ServerCommandSource source, UUID uuid, String name) {
        int balance = BalanceManager.getBalance(uuid);
        String formattedBalance = BalCommand.formatBalance(balance);
        MutableText message = Text.literal((String)"Balance of ").setStyle(Style.EMPTY.withColor(0xBEBEBE)).append((Text)Text.literal((String)name).setStyle(Style.EMPTY.withColor(16745216))).append((Text)Text.literal((String)" is ").setStyle(Style.EMPTY.withColor(0xBEBEBE))).append((Text)Text.literal((String)("$" + formattedBalance)).setStyle(Style.EMPTY.withColor(16745216)));
        source.sendFeedback(() -> message, false);
        return 1;
    }

    private static String formatBalance(int balance) {
        if (balance >= 1000000000) {
            return String.format("%.1fB", (double)balance / 1.0E9);
        }
        if (balance >= 1000000) {
            return String.format("%.1fM", (double)balance / 1000000.0);
        }
        if (balance >= 1000) {
            return String.format("%.1fK", (double)balance / 1000.0);
        }
        return String.format("%d", balance);
    }
}

