/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappaessentials.economy;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.kappasmp.kappaessentials.economy.BalanceManager;
import net.minecraft.server.command.CommandManager;
import net.minecraft.server.command.ServerCommandSource;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.text.Text;

public class PayCommand {
    public static void register(CommandDispatcher<ServerCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)CommandManager.literal((String)"pay").then(CommandManager.argument((String)"player", (ArgumentType)StringArgumentType.string()).then(CommandManager.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            ServerCommandSource source = (ServerCommandSource)context.getSource();
            ServerPlayerEntity sender = source.getPlayer();
            String targetName = StringArgumentType.getString((CommandContext)context, (String)"player");
            int amount = IntegerArgumentType.getInteger((CommandContext)context, (String)"amount");
            ServerPlayerEntity target = source.getServer().getPlayerManager().getPlayer(targetName);
            if (target == null) {
                source.sendFeedback(() -> Text.literal((String)"\u00a7cPlayer not found."), false);
                return 0;
            }
            if (sender.getUuid().equals(target.getUuid())) {
                source.sendFeedback(() -> Text.literal((String)"\u00a7cYou can't pay yourself!"), false);
                return 0;
            }
            int senderBalance = BalanceManager.getBalance(sender.getUuid());
            if (senderBalance < amount) {
                source.sendFeedback(() -> Text.literal((String)"\u00a7cYou don't have enough money!"), false);
                return 0;
            }
            BalanceManager.addBalance(sender.getUuid(), -amount);
            BalanceManager.addBalance(target.getUuid(), amount);
            source.sendFeedback(() -> Text.literal((String)("\u00a7aYou paid \u00a7e" + target.getName().getString() + " \u00a7a$" + amount)), false);
            target.sendMessage((Text)Text.literal((String)("\u00a7aYou received \u00a7a$" + amount + " \u00a7afrom \u00a7e" + sender.getName().getString())));
            return 1;
        }))));
    }
}

