/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappaessentials.economy;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.kappasmp.kappaessentials.economy.BalanceManager;
import net.minecraft.item.ItemStack;
import net.minecraft.registry.Registries;
import net.minecraft.server.command.CommandManager;
import net.minecraft.server.command.ServerCommandSource;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.text.MutableText;
import net.minecraft.text.Style;
import net.minecraft.text.Text;

public class SellCommand {
    public static void register(CommandDispatcher<ServerCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)CommandManager.literal((String)"sell").executes(context -> {
            ServerPlayerEntity player = ((ServerCommandSource)context.getSource()).getPlayer();
            ItemStack heldItem = player.getMainHandStack();
            if (heldItem.isEmpty()) {
                player.sendMessage((Text)Text.literal((String)"You're not holding any item to sell.").setStyle(Style.EMPTY.withColor(0xBEBEBE)), false);
                return 0;
            }
            String itemId = Registries.ITEM.getId((Object)heldItem.getItem()).toString();
            int count = heldItem.getCount();
            int pricePerItem = BalanceManager.getItemPrice(itemId);
            if (pricePerItem <= 0) {
                player.sendMessage((Text)Text.literal((String)"You cannot sell this item.").setStyle(Style.EMPTY.withColor(0xBEBEBE)), false);
                return 0;
            }
            int totalValue = pricePerItem * count;
            heldItem.decrement(count);
            BalanceManager.addBalance(player.getUuid(), totalValue);
            MutableText message = Text.literal((String)"Sold ").setStyle(Style.EMPTY.withColor(0xBEBEBE)).append((Text)Text.literal((String)(count + "x ")).setStyle(Style.EMPTY.withColor(16745216))).append((Text)Text.literal((String)(itemId.split(":")[1] + " ")).setStyle(Style.EMPTY.withColor(0xBEBEBE))).append((Text)Text.literal((String)"for ").setStyle(Style.EMPTY.withColor(0xBEBEBE))).append((Text)Text.literal((String)("$" + totalValue)).setStyle(Style.EMPTY.withColor(16745216)));
            player.sendMessage((Text)message, false);
            return 1;
        })).then(CommandManager.literal((String)"inventory").executes(context -> {
            ServerPlayerEntity player = ((ServerCommandSource)context.getSource()).getPlayer();
            int totalValue = 0;
            for (int i = 0; i < player.getInventory().size(); ++i) {
                String itemId;
                int pricePerItem;
                ItemStack stack = player.getInventory().getStack(i);
                if (stack.isEmpty() || (pricePerItem = BalanceManager.getItemPrice(itemId = Registries.ITEM.getId((Object)stack.getItem()).toString())) <= 0) continue;
                int itemTotalValue = pricePerItem * stack.getCount();
                totalValue += itemTotalValue;
                stack.decrement(stack.getCount());
            }
            if (totalValue > 0) {
                BalanceManager.addBalance(player.getUuid(), totalValue);
                MutableText message = Text.literal((String)"Sold all items in your inventory for ").setStyle(Style.EMPTY.withColor(0xBEBEBE)).append((Text)Text.literal((String)("$" + totalValue)).setStyle(Style.EMPTY.withColor(16745216)));
                player.sendMessage((Text)message, false);
            } else {
                player.sendMessage((Text)Text.literal((String)"You don't have any sellable items in your inventory.").setStyle(Style.EMPTY.withColor(0xBEBEBE)), false);
            }
            return 1;
        })));
    }
}

