/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappaessentials.gui;

import com.mojang.authlib.GameProfile;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.AnvilInputGui;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.text.NumberFormat;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kappasmp.kappaessentials.bounty.BountyManager;
import net.kappasmp.kappaessentials.economy.BalanceManager;
import net.minecraft.item.Items;
import net.minecraft.screen.ScreenHandlerType;
import net.minecraft.server.command.ServerCommandSource;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.text.Text;
import net.minecraft.util.Formatting;

public class BountyGui
extends SimpleGui {
    public BountyGui(ServerPlayerEntity player) {
        super(ScreenHandlerType.GENERIC_9X6, player, false);
        this.setTitle((Text)Text.literal((String)"> \u0299\u1d0f\u1d1c\u0274\u1d1b\u026a\u1d07\ua731").formatted(Formatting.DARK_GRAY));
        int slot = 0;
        Set<UUID> bountiedPlayers = BountyManager.getAllBountiedPlayers();
        if (bountiedPlayers.isEmpty()) {
            this.setSlot(22, (GuiElementBuilderInterface)new GuiElementBuilder(Items.BARRIER).setName((Text)Text.literal((String)"No bounties yet!").formatted(Formatting.DARK_GRAY)).addLoreLine((Text)Text.literal((String)"\u00a77Use the anvil below to add one.")));
        } else {
            List sortedBountiedPlayers = bountiedPlayers.stream().sorted((uuid1, uuid2) -> Integer.compare(BountyManager.getBounty(uuid2), BountyManager.getBounty(uuid1))).collect(Collectors.toList());
            for (UUID targetUUID : sortedBountiedPlayers) {
                String name = BountyGui.getPlayerName(player.getServer().getCommandSource(), targetUUID);
                int amount = BountyManager.getBounty(targetUUID);
                String formattedAmount = BountyGui.formatMoney(amount);
                this.setSlot(slot++, (GuiElementBuilderInterface)new GuiElementBuilder(Items.PLAYER_HEAD).setSkullOwner(targetUUID.toString()).setName((Text)Text.literal((String)("\u2620 " + name)).formatted(Formatting.GOLD)).addLoreLine((Text)Text.literal((String)("\u00a77\u0299\u1d0f\u1d1c\u0274\u1d1b\u028f: \u00a7c" + formattedAmount))).setCallback((i, t, a, gui) -> player.sendMessage((Text)Text.literal((String)("\u1d1b\u1d00\u0280\u0262\u1d07\u1d1b: " + name + " \u029c\u1d00\u0455 \u1d00 $" + formattedAmount + " bounty.")), false)));
            }
        }
        this.setSlot(49, (GuiElementBuilderInterface)new GuiElementBuilder(Items.ANVIL).setName((Text)Text.literal((String)"\u2795 \u0455\u1d07\u1d1b \u0274\u1d07\u1d21 \u0299\u1d0f\u1d1c\u0274\u1d1b\u026a\u1d07").formatted(new Formatting[]{Formatting.GREEN, Formatting.BOLD})).addLoreLine((Text)Text.literal((String)"\u1d04\u029f\u026a\u1d04\u1d0b \u1d1b\u1d0f \u0455\u1d07\u1d1b \u1d00 \u0299\u1d0f\u1d1c\u0274\u1d1b\u026a\u1d07 \u1d0f\u0274 \u1d00 \u1d18\u029f\u1d00\u028f\u1d07\u0280.")).setCallback((i, t, a, gui) -> {
            player.closeHandledScreen();
            new SelectBountyTargetGui(player).open();
        }));
    }

    public static String formatMoney(int amount) {
        if (amount >= 1000000000) {
            return amount / 1000000000 + "B";
        }
        if (amount >= 1000000) {
            return amount / 1000000 + "M";
        }
        if (amount >= 1000) {
            return amount / 1000 + "K";
        }
        return String.valueOf(amount);
    }

    private static String getPlayerName(ServerCommandSource source, UUID uuid) {
        ServerPlayerEntity player = source.getServer().getPlayerManager().getPlayer(uuid);
        if (player != null) {
            return player.getName().getString();
        }
        Optional profile = source.getServer().getUserCache().getByUuid(uuid);
        return profile.map(GameProfile::getName).orElse(uuid.toString().substring(0, 8));
    }

    public static class SelectBountyTargetGui
    extends SimpleGui {
        public SelectBountyTargetGui(ServerPlayerEntity player) {
            super(ScreenHandlerType.GENERIC_9X6, player, false);
            this.setTitle((Text)Text.literal((String)"> \u0455\u1d07\u029f\u1d07\u1d04\u1d1b \u1d1b\u1d00\u0280\u0262\u1d07\u1d1b").formatted(Formatting.DARK_GRAY));
            int slot = 0;
            for (ServerPlayerEntity target : player.getServer().getPlayerManager().getPlayerList()) {
                if (target.getUuid().equals(player.getUuid())) continue;
                int amount = BountyManager.getBounty(target.getUuid());
                String formattedAmount = NumberFormat.getInstance().format(amount);
                this.setSlot(slot++, (GuiElementBuilderInterface)new GuiElementBuilder(Items.PLAYER_HEAD).setSkullOwner(target.getName().getString()).setName((Text)Text.literal((String)("\u2620 " + target.getName().getString())).formatted(Formatting.GOLD)).addLoreLine((Text)Text.literal((String)("\u00a77Bounty: \u00a7c$" + formattedAmount))).setCallback((i, t, a, gui) -> {
                    player.sendMessage((Text)Text.literal((String)("Target: " + target.getName().getString() + " has a $" + formattedAmount + " bounty.")), false);
                    player.closeHandledScreen();
                    this.openAmountInput(player, target);
                }));
            }
        }

        private void openAmountInput(ServerPlayerEntity source, ServerPlayerEntity target) {
            AnvilInputGui inputGui = new AnvilInputGui(source, false);
            inputGui.setSlot(1, (GuiElementBuilderInterface)new GuiElementBuilder(Items.PAPER).setName((Text)Text.literal((String)"\u00a7e\u1d07\u0274\u1d1b\u1d07\u0280 \u0299\u1d0f\u1d1c\u0274\u1d1b\u026a\u1d07\ua731 \u1d00\u1d0d\u1d0f\u1d1c\u0274\u1d1b")).addLoreLine((Text)Text.literal((String)"\u00a77Type an amount and click here.")).setCallback((index, type, action, gui) -> {
                String text = inputGui.getInput();
                try {
                    int amount = Integer.parseInt(text);
                    if (amount <= 0) {
                        throw new NumberFormatException();
                    }
                    if (BalanceManager.getBalance(source.getUuid()) < amount) {
                        source.sendMessage((Text)Text.literal((String)"\u00a7cYou don't have enough balance to set this bounty."));
                        return;
                    }
                    BountyManager.setBounty(target.getUuid(), source.getUuid(), amount);
                    BalanceManager.addBalance(source.getUuid(), -amount);
                    source.sendMessage((Text)Text.literal((String)("\u00a7a\u0299\u1d0f\u1d1c\u0274\u1d1b\u028f \u0455\u1d07\u1d1b \u1d0f\u0274 \u00a7e" + target.getName().getString() + " \u00a7afor \u00a7c$" + BountyGui.formatMoney(amount))));
                }
                catch (NumberFormatException e) {
                    source.sendMessage((Text)Text.literal((String)"\u00a7c\u026a\u0274\u1d20\u1d00\u029f\u026a\u1d05 \u0299\u1d0f\u1d1c\u0274\u1d1b\u028f \u1d00\u1d0d\u1d0f\u1d1c\u0274\u1d1b."));
                }
                gui.close();
            }));
            inputGui.open();
        }
    }
}

