/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappaessentials.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.List;
import java.util.UUID;
import net.kappasmp.kappaessentials.economy.BalanceManager;
import net.kappasmp.kappaessentials.token.TokenManager;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.registry.Registries;
import net.minecraft.screen.ScreenHandlerType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.text.Text;
import net.minecraft.util.Formatting;

public class ShopGui
extends SimpleGui {
    public ShopGui(ServerPlayerEntity player) {
        super(ScreenHandlerType.GENERIC_9X3, player, false);
        this.setTitle((Text)Text.literal((String)"> \u0455\u029c\u1d0f\u1d18").formatted(Formatting.DARK_GRAY));
        this.setSlot(11, (GuiElementBuilderInterface)new GuiElementBuilder(Items.TOTEM_OF_UNDYING).setName((Text)Text.literal((String)"\u1d18\u1d20\u1d18 \u0455\u029c\u1d0f\u1d18").formatted(new Formatting[]{Formatting.DARK_RED, Formatting.BOLD})).setCallback((index, type, action, gui) -> {
            player.sendMessage((Text)Text.literal((String)"Opening PvP Shop..."), false);
            this.openPvpShop(player);
        }));
        this.setSlot(12, (GuiElementBuilderInterface)new GuiElementBuilder(Items.COOKED_BEEF).setName((Text)Text.literal((String)"\ua730\u1d0f\u1d0f\u1d05 \u0455\u029c\u1d0f\u1d18").formatted(new Formatting[]{Formatting.GOLD, Formatting.BOLD})).setCallback((index, type, action, gui) -> {
            player.sendMessage((Text)Text.literal((String)"Opening Food Shop..."), false);
            this.openFoodShop(player);
        }));
        this.setSlot(13, (GuiElementBuilderInterface)new GuiElementBuilder(Items.ENDER_PEARL).setName((Text)Text.literal((String)"\u1d07\u0274\u1d05 \u0455\u029c\u1d0f\u1d18").formatted(new Formatting[]{Formatting.LIGHT_PURPLE, Formatting.BOLD})).setCallback((index, type, action, gui) -> {
            player.sendMessage((Text)Text.literal((String)"Opening End Shop..."), false);
            this.openEndShop(player);
        }));
        this.setSlot(14, (GuiElementBuilderInterface)new GuiElementBuilder(Items.NETHERRACK).setName((Text)Text.literal((String)"\u0274\u1d07\u1d1b\u029c\u1d07\u0280 \u0455\u029c\u1d0f\u1d18").formatted(new Formatting[]{Formatting.RED, Formatting.BOLD})).setCallback((index, type, action, gui) -> {
            player.sendMessage((Text)Text.literal((String)"Opening Nether Shop..."), false);
            this.openNetherShop(player);
        }));
        this.setSlot(15, (GuiElementBuilderInterface)new GuiElementBuilder(Items.AMETHYST_SHARD).setName((Text)Text.literal((String)"\u1d1b\u1d0f\u1d0b\u1d07\u0274 \u0455\u029c\u1d0f\u1d18").formatted(new Formatting[]{Formatting.DARK_PURPLE, Formatting.BOLD})).setCallback((index, type, action, gui) -> {
            player.sendMessage((Text)Text.literal((String)"Opening Token Shop..."), false);
            this.openTokenShop(player);
        }));
    }

    private void openPvpShop(ServerPlayerEntity player) {
        this.setTitle((Text)Text.literal((String)"\u00a77> \u1d18\u1d20\u1d18 \u0455\u029c\u1d0f\u1d18"));
        for (int i = 0; i < 27; ++i) {
            this.setSlot(i, (GuiElementBuilderInterface)new GuiElementBuilder(Items.GRAY_STAINED_GLASS_PANE).setName((Text)Text.literal((String)"")));
        }
        this.addShopItem(player, 10, Items.TOTEM_OF_UNDYING, 1250, 1);
        this.addShopItem(player, 11, Items.END_CRYSTAL, 900, 16);
        this.addShopItem(player, 12, Items.OBSIDIAN, 550, 64);
        this.addShopItem(player, 13, Items.RESPAWN_ANCHOR, 1100, 4);
        this.addShopItem(player, 14, Items.GLOWSTONE, 900, 32);
        this.addShopItem(player, 15, Items.GOLDEN_APPLE, 900, 8);
        this.addShopItem(player, 16, Items.ENDER_PEARL, 200, 16);
    }

    private void openFoodShop(ServerPlayerEntity player) {
        this.setTitle((Text)Text.literal((String)"\u00a77> \ua730\u1d0f\u1d0f\u1d05 \u0455\u029c\u1d0f\u1d18"));
        for (int i = 0; i < 27; ++i) {
            this.setSlot(i, (GuiElementBuilderInterface)new GuiElementBuilder(Items.GRAY_STAINED_GLASS_PANE).setName((Text)Text.literal((String)"")));
        }
        this.addShopItem(player, 11, Items.COOKED_BEEF, 100, 32);
        this.addShopItem(player, 12, Items.COOKED_CHICKEN, 900, 16);
        this.addShopItem(player, 13, Items.GOLDEN_APPLE, 900, 8);
        this.addShopItem(player, 14, Items.GOLDEN_CARROT, 50, 4);
        this.addShopItem(player, 15, Items.COOKED_PORKCHOP, 100, 32);
    }

    private void openEndShop(ServerPlayerEntity player) {
        this.setTitle((Text)Text.literal((String)"\u00a77> \u1d07\u0274\u1d05 \u0455\u029c\u1d0f\u1d18"));
        for (int i = 0; i < 27; ++i) {
            this.setSlot(i, (GuiElementBuilderInterface)new GuiElementBuilder(Items.GRAY_STAINED_GLASS_PANE).setName((Text)Text.literal((String)"")));
        }
        this.addShopItem(player, 11, Items.ENDER_PEARL, 200, 16);
        this.addShopItem(player, 12, Items.ENDER_CHEST, 900, 16);
        this.addShopItem(player, 13, Items.SHULKER_BOX, 750, 1);
        this.addShopItem(player, 14, Items.FIREWORK_ROCKET, 1000, 32);
        this.addShopItem(player, 15, Items.ELYTRA, 300000, 1);
    }

    private void openNetherShop(ServerPlayerEntity player) {
        this.setTitle((Text)Text.literal((String)"\u00a77> \u0274\u1d07\u1d1b\u029c\u1d07\u0280 \u0455\u029c\u1d0f\u1d18"));
        for (int i = 0; i < 27; ++i) {
            this.setSlot(i, (GuiElementBuilderInterface)new GuiElementBuilder(Items.GRAY_STAINED_GLASS_PANE).setName((Text)Text.literal((String)"")));
        }
        this.addShopItem(player, 11, Items.NETHERRACK, 200, 32);
        this.addShopItem(player, 12, Items.GLOWSTONE, 900, 32);
        this.addShopItem(player, 13, Items.QUARTZ, 750, 32);
        this.addShopItem(player, 14, Items.MAGMA_CREAM, 1000, 1);
        this.addShopItem(player, 15, Items.MAGMA_BLOCK, 550, 32);
    }

    private void openTokenShop(ServerPlayerEntity player) {
        this.setTitle((Text)Text.literal((String)"\u00a77> X\u1d1b\u1d0f\u1d0b\u1d07\u0274 \u0455\u029c\u1d0f\u1d18"));
        for (int i = 0; i < 27; ++i) {
            this.setSlot(i, (GuiElementBuilderInterface)new GuiElementBuilder(Items.GRAY_STAINED_GLASS_PANE).setName((Text)Text.literal((String)"")));
        }
        this.setSlot(11, (GuiElementBuilderInterface)new GuiElementBuilder(Items.SPAWNER).setName((Text)Text.literal((String)"\u00a7aCreeper Spawner")).setLore(List.of(Text.literal((String)"\u00a77Click to purchase"), Text.literal((String)"\u00a76 Token Cost: 200"), Text.literal((String)"\u00a76Amount: \u00a7e1"))).setCallback((index, type, action, gui) -> {
            int price;
            UUID playerUUID = player.getUuid();
            if (TokenManager.withdrawTokens(playerUUID, price = 200)) {
                String command = "/give " + player.getName().getString() + " spawner[block_entity_data={id:\"mob_spawner\",SpawnData:{entity:{id:\"minecraft:creeper\"}}}] 1";
                player.getServer().getCommandManager().executeWithPrefix(player.getServer().getCommandSource(), command);
                player.sendMessage((Text)Text.literal((String)"\u00a7aYou purchased a Creeper Spawner!"), false);
            } else {
                player.sendMessage((Text)Text.literal((String)"\u00a7cYou do not have enough Tokens to purchase this item."), false);
            }
        }));
        this.setSlot(12, (GuiElementBuilderInterface)new GuiElementBuilder(Items.SPAWNER).setName((Text)Text.literal((String)"\u00a7aZombie Spawner")).setLore(List.of(Text.literal((String)"\u00a77Click to purchase"), Text.literal((String)"\u00a76 Token Cost: 150"), Text.literal((String)"\u00a76Amount: \u00a7e1"))).setCallback((index, type, action, gui) -> {
            int price;
            UUID playerUUID = player.getUuid();
            if (TokenManager.withdrawTokens(playerUUID, price = 150)) {
                String command = "/give " + player.getName().getString() + " spawner[block_entity_data={id:\"mob_spawner\",SpawnData:{entity:{id:\"minecraft:zombie\"}}}] 1";
                player.getServer().getCommandManager().executeWithPrefix(player.getServer().getCommandSource(), command);
                player.sendMessage((Text)Text.literal((String)"\u00a7aYou purchased a Zombie Spawner!"), false);
            } else {
                player.sendMessage((Text)Text.literal((String)"\u00a7cYou do not have enough Tokens to purchase this item."), false);
            }
        }));
        this.setSlot(13, (GuiElementBuilderInterface)new GuiElementBuilder(Items.SPAWNER).setName((Text)Text.literal((String)"\u00a7aSkeleton Spawner")).setLore(List.of(Text.literal((String)"\u00a77Click to purchase"), Text.literal((String)"\u00a76 Token Cost: 400"), Text.literal((String)"\u00a76Amount: \u00a7e1"))).setCallback((index, type, action, gui) -> {
            int price;
            UUID playerUUID = player.getUuid();
            if (TokenManager.withdrawTokens(playerUUID, price = 400)) {
                String command = "/give " + player.getName().getString() + " spawner[block_entity_data={id:\"mob_spawner\",SpawnData:{entity:{id:\"minecraft:skeleton\"}}}] 1";
                player.getServer().getCommandManager().executeWithPrefix(player.getServer().getCommandSource(), command);
                player.sendMessage((Text)Text.literal((String)"\u00a7aYou purchased a Skeleton Spawner!"), false);
            } else {
                player.sendMessage((Text)Text.literal((String)"\u00a7cYou do not have enough Tokens to purchase this item."), false);
            }
        }));
        this.setSlot(14, (GuiElementBuilderInterface)new GuiElementBuilder(Items.SPAWNER).setName((Text)Text.literal((String)"\u00a7aCow Spawner")).setLore(List.of(Text.literal((String)"\u00a77Click to purchase"), Text.literal((String)"\u00a76 Token Cost: 50"), Text.literal((String)"\u00a76Amount: \u00a7e1"))).setCallback((index, type, action, gui) -> {
            int price;
            UUID playerUUID = player.getUuid();
            if (TokenManager.withdrawTokens(playerUUID, price = 50)) {
                String command = "/give " + player.getName().getString() + " spawner[block_entity_data={id:\"mob_spawner\",SpawnData:{entity:{id:\"minecraft:cow\"}}}] 1";
                player.getServer().getCommandManager().executeWithPrefix(player.getServer().getCommandSource(), command);
                player.sendMessage((Text)Text.literal((String)"\u00a7aYou purchased a Cow Spawner!"), false);
            } else {
                player.sendMessage((Text)Text.literal((String)"\u00a7cYou do not have enough Tokens to purchase this item."), false);
            }
        }));
        this.setSlot(15, (GuiElementBuilderInterface)new GuiElementBuilder(Items.SPAWNER).setName((Text)Text.literal((String)"\u00a7aIron Golem Spawner")).setLore(List.of(Text.literal((String)"\u00a77Click to purchase"), Text.literal((String)"\u00a76 Token Cost: 1250"), Text.literal((String)"\u00a76Amount: \u00a7e1"))).setCallback((index, type, action, gui) -> {
            int price;
            UUID playerUUID = player.getUuid();
            if (TokenManager.withdrawTokens(playerUUID, price = 1250)) {
                String command = "/give " + player.getName().getString() + " spawner[block_entity_data={id:\"mob_spawner\",SpawnData:{entity:{id:\"minecraft:iron_golem\"}}}] 1";
                player.getServer().getCommandManager().executeWithPrefix(player.getServer().getCommandSource(), command);
                player.sendMessage((Text)Text.literal((String)"\u00a7aYou purchased an Iron Golem Spawner!"), false);
            } else {
                player.sendMessage((Text)Text.literal((String)"\u00a7cYou do not have enough Tokens to purchase this item."), false);
            }
        }));
        this.setSlot(4, (GuiElementBuilderInterface)new GuiElementBuilder(Items.NETHERITE_SWORD).setName((Text)Text.literal((String)"\u00a75\u00a7l\u1d1b\u029c\u1d07 \u1d22\u1d07\u0274\u026a\u1d1b\u029c").formatted(Formatting.DARK_PURPLE)).setLore(List.of(Text.literal((String)"\u00a77Click to purchase"), Text.literal((String)"\u00a77Sharpness X"), Text.literal((String)"\u00a77Smite V"), Text.literal((String)"\u00a77Bane of Arthopods V"), Text.literal((String)"\u00a77Sweeping Edge 5"), Text.literal((String)"\u00a77Knockback II"), Text.literal((String)"\u00a77Looting V"), Text.literal((String)"\u00a77Silk Touch"), Text.literal((String)"\u00a77Unbreaking V"), Text.literal((String)"\u00a77Mending"), Text.literal((String)"\u00a76 Token Cost: 500"))).setCallback((index, type, action, gui) -> {
            int price;
            UUID playerUUID = player.getUuid();
            if (TokenManager.withdrawTokens(playerUUID, price = 500)) {
                String command = "/give " + player.getName().getString() + " netherite_sword[custom_name='[\"\",{\"text\":\"\u1d1b\u029c\u1d07 \u1d22\u1d07\u0274\u026a\u1d1b\u029c\",\"italic\":false,\"color\":\"dark_purple\",\"bold\":true}]',rarity=epic,enchantments={levels:{bane_of_arthropods:5,knockback:2,looting:5,mending:1,sharpness:10,unbreaking:5,silk_touch:1,smite:5,sweeping_edge:5}}]";
                player.getServer().getCommandManager().executeWithPrefix(player.getServer().getCommandSource(), command);
                player.sendMessage((Text)Text.literal((String)"\u00a7aYou purchased The Zenith!"), false);
            } else {
                player.sendMessage((Text)Text.literal((String)"\u00a7cYou do not have enough Tokens to purchase this item."), false);
            }
        }));
        this.setSlot(5, (GuiElementBuilderInterface)new GuiElementBuilder(Items.NETHERITE_AXE).setName((Text)Text.literal((String)"\u00a76\u00a7l\u029f\u1d07\u0262\u1d07\u0274\u1d05\u1d00\u0280\u028f \u1d00\u0445\u1d07")).setLore(List.of(Text.literal((String)"\u00a77Click to purchase"), Text.literal((String)"\u00a77Sharpness X"), Text.literal((String)"\u00a77Smite V"), Text.literal((String)"\u00a77Bane of Arthopods V"), Text.literal((String)"\u00a77Knockback II"), Text.literal((String)"\u00a77Efficiency VII"), Text.literal((String)"\u00a77Silk Touch II"), Text.literal((String)"\u00a77Mending"), Text.literal((String)"\u00a76 Token Cost: 400"))).setCallback((index, type, action, gui) -> {
            int price;
            UUID playerUUID = player.getUuid();
            if (TokenManager.withdrawTokens(playerUUID, price = 400)) {
                String command = "/give " + player.getName().getString() + " netherite_axe[custom_name='[\"\",{\"text\":\"\u029f\u1d07\u0262\u1d07\u0274\u1d05\u1d00\u0280\u028f \u1d00\u0445\u1d07\",\"italic\":false,\"color\":\"gold\",\"bold\":true}]',rarity=epic,enchantments={levels:{bane_of_arthropods:5,efficiency:7,knockback:2,mending:1,sharpness:10,silk_touch:1,unbreaking:5,smite:5}}]";
                player.getServer().getCommandManager().executeWithPrefix(player.getServer().getCommandSource(), command);
                player.sendMessage((Text)Text.literal((String)"\u00a7aYou purchased the Legendary Axe!"), false);
            } else {
                player.sendMessage((Text)Text.literal((String)"\u00a7cYou do not have enough Tokens to purchase this item."), false);
            }
        }));
        this.setSlot(3, (GuiElementBuilderInterface)new GuiElementBuilder(Items.NETHERITE_PICKAXE).setName((Text)Text.literal((String)"\u00a76\u00a7l\u029f\u1d07\u0262\u1d07\u0274\u1d05\u1d00\u0280\u028f \u1d18\u026a\u1d04\u1d0b\u1d00\u0445\u1d07")).setLore(List.of(Text.literal((String)"\u00a77Click to purchase"), Text.literal((String)"\u00a77Efficiency VIII"), Text.literal((String)"\u00a77Fortune V"), Text.literal((String)"\u00a77Unbreaking VI"), Text.literal((String)"\u00a77Mending"), Text.literal((String)"\u00a76 Token Cost: 300"))).setCallback((index, type, action, gui) -> {
            int price;
            UUID playerUUID = player.getUuid();
            if (TokenManager.withdrawTokens(playerUUID, price = 300)) {
                String command = "/give " + player.getName().getString() + " netherite_pickaxe[custom_name='[\"\",{\"text\":\"\u029f\u1d07\u0262\u1d07\u0274\u1d05\u1d00\u0280\u028f \u1d18\u026a\u1d04\u1d0b\u1d00\u0445\u1d07\",\"italic\":false,\"color\":\"gold\",\"bold\":true}]',rarity=epic,enchantments={levels:{efficiency:8,fortune:5,mending:1,unbreaking:6}}]";
                player.getServer().getCommandManager().executeWithPrefix(player.getServer().getCommandSource(), command);
                player.sendMessage((Text)Text.literal((String)"\u00a7aYou purchased the Legendary Pickaxe!"), false);
            } else {
                player.sendMessage((Text)Text.literal((String)"\u00a7cYou do not have enough Tokens to purchase this item."), false);
            }
        }));
    }

    private void addShopItem(ServerPlayerEntity player, int slot, Item item, int price, int amount) {
        this.setSlot(slot, (GuiElementBuilderInterface)new GuiElementBuilder(item).setName((Text)Text.literal((String)("\u00a7f" + item.getName().getString()))).setLore(List.of(Text.literal((String)"\u00a77Click to purchase"), Text.literal((String)("\u00a76\ud83d\udcb0 Cost: \u00a7e" + price + " Coins")), Text.literal((String)("\u00a76Amount: \u00a7e" + amount)))).setCallback((index, type, action, gui) -> this.purchaseItem(player, item, price, amount)));
    }

    private void purchaseItem(ServerPlayerEntity player, Item item, int price, int amount) {
        UUID playerUUID = player.getUuid();
        if (BalanceManager.withdrawBalance(playerUUID, price)) {
            this.givePlayerItem(player.getServer(), player, item, amount);
            player.sendMessage((Text)Text.literal((String)("\u00a77You purchased \u00a7f" + amount + "x " + item.getName().getString() + " \u00a77for \u00a7e" + price + " Coins\u00a77.")), false);
        } else {
            player.sendMessage((Text)Text.literal((String)"\u00a7cYou do not have enough Money to purchase this item."), false);
        }
    }

    private void givePlayerItem(MinecraftServer server, ServerPlayerEntity player, Item item, int amount) {
        String itemId = Registries.ITEM.getId((Object)item).toString();
        String giveCommand = "give " + player.getName().getString() + " " + itemId + " " + amount;
        server.getCommandManager().executeWithPrefix(server.getCommandSource(), giveCommand);
    }
}

