/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappaessentials.homes;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.kappasmp.kappaessentials.homes.HomeManager;
import net.kappasmp.kappaessentials.util.TaskScheduler;
import net.minecraft.network.packet.s2c.play.PositionFlag;
import net.minecraft.registry.RegistryKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.command.CommandManager;
import net.minecraft.server.command.ServerCommandSource;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.text.Text;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class HomeCommand {
    private static final int TELEPORT_DELAY_SECONDS = 5;
    private static final SuggestionProvider<ServerCommandSource> HOME_NAME_SUGGESTIONS = (context, builder) -> {
        ServerPlayerEntity player = ((ServerCommandSource)context.getSource()).getPlayer();
        Map<String, HomeManager.HomeData> homes = HomeManager.getHomes(player);
        homes.keySet().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<ServerCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)CommandManager.literal((String)"home").then(CommandManager.argument((String)"homeName", (ArgumentType)StringArgumentType.string()).suggests(HOME_NAME_SUGGESTIONS).executes(context -> {
            ServerPlayerEntity player = ((ServerCommandSource)context.getSource()).getPlayer();
            MinecraftServer server = ((ServerCommandSource)context.getSource()).getServer();
            String homeName = StringArgumentType.getString((CommandContext)context, (String)"homeName");
            HomeManager.HomeData home = HomeManager.getHome(player, homeName);
            if (home == null) {
                player.sendMessage((Text)Text.literal((String)("\u00a7cHome not found: " + homeName)), false);
                return 1;
            }
            ServerWorld targetWorld = server.getWorld(home.dimension);
            if (targetWorld == null) {
                player.sendMessage((Text)Text.literal((String)("\u00a7cWorld not found: " + String.valueOf(home.dimension.getValue()))), false);
                return 1;
            }
            BlockPos pos = home.pos;
            ChunkPos chunkPos = new ChunkPos(pos);
            for (int second = 1; second <= 5; ++second) {
                int timeLeft = 5 - second + 1;
                int delayTicks = second * 20;
                TaskScheduler.scheduleMessage(player, delayTicks, () -> player.sendMessage((Text)Text.literal((String)("\u00a77Teleporting in \u00a7e" + timeLeft + "\u00a77...")), false));
            }
            TaskScheduler.scheduleTeleport(player, 100, () -> CompletableFuture.runAsync(() -> targetWorld.getChunk(chunkPos.x, chunkPos.z), (Executor)server).thenRunAsync(() -> {
                HomeCommand.teleportSafely(player, targetWorld, pos);
                player.sendMessage((Text)Text.literal((String)("\u00a7aTeleported to home: " + homeName)), false);
            }, (Executor)server), homeName);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)CommandManager.literal((String)"sethome").then(CommandManager.argument((String)"homeName", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String homeName;
            ServerPlayerEntity player = ((ServerCommandSource)context.getSource()).getPlayer();
            if (HomeManager.getHome(player, homeName = StringArgumentType.getString((CommandContext)context, (String)"homeName")) != null) {
                player.sendMessage((Text)Text.literal((String)("\u00a7cHome already exists: " + homeName)), false);
                return 1;
            }
            RegistryKey worldKey = player.getWorld().getRegistryKey();
            BlockPos pos = player.getBlockPos();
            HomeManager.HomeData home = new HomeManager.HomeData(pos, (RegistryKey<World>)worldKey);
            HomeManager.setHome(player, homeName, home);
            player.sendMessage((Text)Text.literal((String)("\u00a7aHome '" + homeName + "' has been set.")), false);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)CommandManager.literal((String)"delhome").then(CommandManager.argument((String)"homeName", (ArgumentType)StringArgumentType.string()).suggests(HOME_NAME_SUGGESTIONS).executes(context -> {
            ServerPlayerEntity player = ((ServerCommandSource)context.getSource()).getPlayer();
            String homeName = StringArgumentType.getString((CommandContext)context, (String)"homeName");
            Map<String, HomeManager.HomeData> homes = HomeManager.getHomes(player);
            if (!homes.containsKey(homeName)) {
                player.sendMessage((Text)Text.literal((String)("\u00a7cHome not found: " + homeName)), false);
                return 1;
            }
            HomeManager.removeHome(player, homeName);
            player.sendMessage((Text)Text.literal((String)("\u00a7aHome '" + homeName + "' has been deleted.")), false);
            return 1;
        })));
    }

    private static void teleportSafely(ServerPlayerEntity player, ServerWorld world, BlockPos pos) {
        double x = (double)pos.getX() + 0.5;
        double y = pos.getY();
        double z = (double)pos.getZ() + 0.5;
        if (player.getServerWorld() != world) {
            player.teleport(world, x, y, z, EnumSet.noneOf(PositionFlag.class), player.getYaw(), player.getPitch(), false);
        } else {
            player.networkHandler.requestTeleport(x, y, z, player.getYaw(), player.getPitch());
        }
    }
}

