/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappaessentials.homes;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kappasmp.kappaessentials.config.ConfigManager;
import net.kappasmp.kappaessentials.config.HomeConfig;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.context.ContextManager;
import net.luckperms.api.model.user.User;
import net.luckperms.api.query.QueryOptions;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.RegistryKeys;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.text.Text;
import net.minecraft.util.Identifier;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HomeManager {
    private static final File FILE = new File("config/KappaEssentials/homes.json");
    private static final Gson GSON = new Gson().newBuilder().setPrettyPrinting().create();
    private static final Map<UUID, Map<String, HomeData>> homes = new HashMap<UUID, Map<String, HomeData>>();
    private static final Map<UUID, Long> lastTeleportTime = new HashMap<UUID, Long>();

    public static void setHome(ServerPlayerEntity player, String name, HomeData data) {
        boolean isNew;
        long elapsed;
        UUID uuid = player.getUuid();
        Map playerHomes = homes.computeIfAbsent(uuid, k -> new HashMap());
        HomeConfig config = ConfigManager.getHomeConfig();
        if (config.cooldownSeconds > 0 && lastTeleportTime.containsKey(uuid) && (elapsed = (System.currentTimeMillis() - lastTeleportTime.get(uuid)) / 1000L) < (long)config.cooldownSeconds) {
            long remaining = (long)config.cooldownSeconds - elapsed;
            player.sendMessage((Text)Text.literal((String)("\u00a7cYou must wait " + remaining + "s before setting another home.")), false);
            return;
        }
        if (!config.crossDimensionAllowed && !player.getWorld().getRegistryKey().equals(data.dimension)) {
            player.sendMessage((Text)Text.literal((String)"\u00a7cYou are not allowed to set homes across dimensions."), false);
            return;
        }
        int maxHomes = config.defaultLimit;
        for (Map.Entry<String, Integer> entry : config.rankLimits.entrySet()) {
            if (!HomeManager.hasLuckPermsPermission(player, entry.getKey())) continue;
            maxHomes = Math.max(maxHomes, entry.getValue());
        }
        boolean bl = isNew = !playerHomes.containsKey(name);
        if (isNew && playerHomes.size() >= maxHomes) {
            player.sendMessage((Text)Text.literal((String)("\u00a7cYou have reached your home limit of \u00a7e" + maxHomes + "\u00a7c.")), false);
            return;
        }
        playerHomes.put(name, data);
        HomeManager.saveHomes();
        lastTeleportTime.put(uuid, System.currentTimeMillis());
        if (config.showCountdownMessages) {
            if (isNew) {
                player.sendMessage((Text)Text.literal((String)("\u00a7aHome '" + name + "' has been set.")), false);
            } else {
                player.sendMessage((Text)Text.literal((String)("\u00a7cHome '" + name + "' already exists (please cure your dementia).")), false);
            }
        }
    }

    public static HomeData getHome(ServerPlayerEntity player, String homeName) {
        return (HomeData)homes.getOrDefault(player.getUuid(), Collections.emptyMap()).get(homeName);
    }

    public static Map<String, HomeData> getHomes(ServerPlayerEntity player) {
        return homes.getOrDefault(player.getUuid(), Collections.emptyMap());
    }

    public static void removeHome(ServerPlayerEntity player, String homeName) {
        UUID uuid = player.getUuid();
        Map<String, HomeData> playerHomes = homes.get(uuid);
        if (playerHomes != null) {
            playerHomes.remove(homeName);
            HomeManager.saveHomes();
        }
    }

    public static void loadHomes() {
        if (!FILE.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(FILE);){
            Type type = new TypeToken<Map<String, JsonObject>>(){}.getType();
            Map loaded = (Map)GSON.fromJson((Reader)reader, type);
            if (loaded != null) {
                homes.clear();
                for (Map.Entry entry : loaded.entrySet()) {
                    UUID uuid = UUID.fromString((String)entry.getKey());
                    JsonObject homesJson = (JsonObject)entry.getValue();
                    HashMap<String, HomeData> playerHomes = new HashMap<String, HomeData>();
                    for (Map.Entry homeEntry : homesJson.entrySet()) {
                        String homeName = (String)homeEntry.getKey();
                        JsonObject posJson = ((JsonElement)homeEntry.getValue()).getAsJsonObject();
                        int x = posJson.get("x").getAsInt();
                        int y = posJson.get("y").getAsInt();
                        int z = posJson.get("z").getAsInt();
                        String dimId = posJson.has("dimension") ? posJson.get("dimension").getAsString() : "minecraft:overworld";
                        Identifier id = Identifier.tryParse((String)dimId);
                        RegistryKey dimension = RegistryKey.of((RegistryKey)RegistryKeys.WORLD, (Identifier)id);
                        playerHomes.put(homeName, new HomeData(new BlockPos(x, y, z), (RegistryKey<World>)dimension));
                    }
                    homes.put(uuid, playerHomes);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load homes.json: " + e.getMessage());
        }
    }

    private static void saveHomes() {
        try {
            FILE.getParentFile().mkdirs();
            HashMap<String, JsonObject> homesToSave = new HashMap<String, JsonObject>();
            for (Map.Entry<UUID, Map<String, HomeData>> entry : homes.entrySet()) {
                JsonObject homesJson = new JsonObject();
                for (Map.Entry<String, HomeData> homeEntry : entry.getValue().entrySet()) {
                    HomeData home = homeEntry.getValue();
                    JsonObject json = new JsonObject();
                    json.addProperty("x", (Number)home.pos.getX());
                    json.addProperty("y", (Number)home.pos.getY());
                    json.addProperty("z", (Number)home.pos.getZ());
                    json.addProperty("dimension", home.dimension.getValue().toString());
                    homesJson.add(homeEntry.getKey(), (JsonElement)json);
                }
                homesToSave.put(entry.getKey().toString(), homesJson);
            }
            try (FileWriter writer = new FileWriter(FILE);){
                GSON.toJson(homesToSave, (Appendable)writer);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to save homes.json: " + e.getMessage());
        }
    }

    private static boolean hasLuckPermsPermission(ServerPlayerEntity player, String permission) {
        try {
            LuckPerms api = LuckPermsProvider.get();
            User user = api.getUserManager().getUser(player.getUuid());
            if (user == null) {
                return false;
            }
            ContextManager contextManager = api.getContextManager();
            QueryOptions queryOptions = contextManager.getQueryOptions(user).orElse(null);
            if (queryOptions == null) {
                return false;
            }
            return user.getCachedData().getPermissionData(queryOptions).checkPermission(permission).asBoolean();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static class HomeData {
        public BlockPos pos;
        public RegistryKey<World> dimension;

        public HomeData(BlockPos pos, RegistryKey<World> dimension) {
            this.pos = pos;
            this.dimension = dimension;
        }
    }
}

