/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappaessentials.manager;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class ShopManager {
    private static final Gson GSON = new Gson();
    private static final Map<String, Double> shopItems = new HashMap<String, Double>();
    private static File shopFile;

    public static void init(Path configDir) {
        shopFile = configDir.resolve("config/KappaEssentials/shop.json").toFile();
        ShopManager.loadShop();
    }

    public static void loadShop() {
        if (!shopFile.exists()) {
            ShopManager.saveShop();
            return;
        }
        try (FileReader reader = new FileReader(shopFile);){
            Type type = new TypeToken<Map<String, Double>>(){}.getType();
            Map loadedShop = (Map)GSON.fromJson((Reader)reader, type);
            shopItems.clear();
            if (loadedShop != null) {
                shopItems.putAll(loadedShop);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveShop() {
        try {
            shopFile.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(shopFile);){
                GSON.toJson(shopItems, (Appendable)writer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setItemPrice(String itemId, double price) {
        shopItems.put(itemId, price);
        ShopManager.saveShop();
    }

    public static Double getItemPrice(String itemId) {
        return shopItems.get(itemId);
    }

    public static Map<String, Double> getShopItems() {
        return shopItems;
    }
}

