/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappaessentials.teleport;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.network.packet.s2c.play.PositionFlag;
import net.minecraft.registry.RegistryKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.text.Text;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HomeTeleportScheduler {
    private static final List<TeleportTask> tasks = new ArrayList<TeleportTask>();

    public static void tick(MinecraftServer server) {
        Iterator<TeleportTask> iterator = tasks.iterator();
        while (iterator.hasNext()) {
            TeleportTask task = iterator.next();
            if (!task.player.getBlockPos().equals((Object)task.startPos)) {
                task.player.sendMessage((Text)Text.literal((String)"\u00a7cYou moved! Teleportation cancelled."), false);
                iterator.remove();
                continue;
            }
            if (task.delayTicks == 0) {
                ServerWorld targetWorld = server.getWorld(task.dimension);
                if (targetWorld == null) {
                    task.player.sendMessage((Text)Text.literal((String)"\u00a7cError: world not found!"), false);
                    iterator.remove();
                    continue;
                }
                task.player.teleport(targetWorld, (double)task.pos.getX() + 0.5, (double)task.pos.getY(), (double)task.pos.getZ() + 0.5, EnumSet.noneOf(PositionFlag.class), task.player.getYaw(), task.player.getPitch(), false);
                task.player.sendMessage((Text)Text.literal((String)("\u00a7aTeleported to home '" + task.name + "'!")), false);
                iterator.remove();
                continue;
            }
            if (task.delayTicks % 20 == 0) {
                int secondsLeft = task.delayTicks / 20;
                task.player.sendMessage((Text)Text.literal((String)("\u00a77Teleporting in " + secondsLeft + "...")), false);
            }
            --task.delayTicks;
        }
    }

    public static void queue(ServerPlayerEntity player, BlockPos pos, RegistryKey<World> dimension, String name) {
        tasks.add(new TeleportTask(player, pos, dimension, name));
    }

    private static class TeleportTask {
        ServerPlayerEntity player;
        BlockPos pos;
        RegistryKey<World> dimension;
        String name;
        int delayTicks = 100;
        BlockPos startPos;

        TeleportTask(ServerPlayerEntity player, BlockPos pos, RegistryKey<World> dimension, String name) {
            this.player = player;
            this.pos = pos;
            this.dimension = dimension;
            this.name = name;
            this.startPos = player.getBlockPos();
        }
    }
}

