/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappaessentials.teleport;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.network.ServerPlayerEntity;

public class TeleportRequestManager {
    private static final Map<UUID, Request> requests = new HashMap<UUID, Request>();

    public static void sendRequest(ServerPlayerEntity from, ServerPlayerEntity to, Type type) {
        requests.put(to.getUuid(), new Request(from, type));
    }

    public static ServerPlayerEntity getRequester(ServerPlayerEntity receiver) {
        Request req = requests.get(receiver.getUuid());
        return req != null ? req.requester : null;
    }

    public static Type getType(ServerPlayerEntity receiver) {
        Request req = requests.get(receiver.getUuid());
        return req != null ? req.type : null;
    }

    public static void clearRequest(ServerPlayerEntity receiver) {
        requests.remove(receiver.getUuid());
    }

    public static boolean hasRequest(ServerPlayerEntity receiver) {
        return requests.containsKey(receiver.getUuid());
    }

    private static class Request {
        public final ServerPlayerEntity requester;
        public final Type type;

        public Request(ServerPlayerEntity requester, Type type) {
            this.requester = requester;
            this.type = type;
        }
    }

    public static enum Type {
        TPA,
        TPAHERE;

    }
}

