/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappaessentials.teleport;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.EnumSet;
import net.kappasmp.kappaessentials.teleport.TeleportRequestManager;
import net.minecraft.network.packet.s2c.play.PositionFlag;
import net.minecraft.server.command.CommandManager;
import net.minecraft.server.command.ServerCommandSource;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.text.Text;

public class TpAcceptCommand {
    public static void register(CommandDispatcher<ServerCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)CommandManager.literal((String)"tpaccept").executes(context -> {
            ServerPlayerEntity receiver = ((ServerCommandSource)context.getSource()).getPlayer();
            if (!TeleportRequestManager.hasRequest(receiver)) {
                receiver.sendMessage((Text)Text.literal((String)"\u00a7cNo pending teleport requests."), false);
                return 0;
            }
            ServerPlayerEntity requester = TeleportRequestManager.getRequester(receiver);
            TeleportRequestManager.Type type = TeleportRequestManager.getType(receiver);
            if (requester == null || type == null) {
                receiver.sendMessage((Text)Text.literal((String)"\u00a7cTeleport request is no longer valid."), false);
                return 0;
            }
            if (type == TeleportRequestManager.Type.TPA) {
                requester.teleport(receiver.getServerWorld(), receiver.getX(), receiver.getY(), receiver.getZ(), EnumSet.noneOf(PositionFlag.class), requester.getYaw(), requester.getPitch(), false);
                requester.sendMessage((Text)Text.literal((String)("\u00a7aTeleported to " + receiver.getName().getString())), false);
            } else {
                receiver.teleport(requester.getServerWorld(), requester.getX(), requester.getY(), requester.getZ(), EnumSet.noneOf(PositionFlag.class), receiver.getYaw(), receiver.getPitch(), false);
                receiver.sendMessage((Text)Text.literal((String)("\u00a7aTeleported to " + requester.getName().getString())), false);
            }
            TeleportRequestManager.clearRequest(receiver);
            return 1;
        }));
    }
}

