/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappaessentials.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.text.Text;
import net.minecraft.util.math.BlockPos;

public class TaskScheduler {
    private static final Map<UUID, ScheduledTeleport> activeTeleports = new HashMap<UUID, ScheduledTeleport>();
    private static final List<ScheduledMessage> scheduledMessages = new LinkedList<ScheduledMessage>();

    public static void scheduleTeleport(ServerPlayerEntity player, int delayTicks, Runnable action, String homeName) {
        BlockPos currentPos = player.getBlockPos();
        activeTeleports.put(player.getUuid(), new ScheduledTeleport(delayTicks, action, currentPos, (Text)Text.literal((String)("\u00a7cTeleport to \u00a7e" + homeName + "\u00a7c cancelled: you moved."))));
    }

    public static void scheduleMessage(ServerPlayerEntity player, int delayTicks, Runnable action) {
        scheduledMessages.add(new ScheduledMessage(player.getUuid(), delayTicks, action));
    }

    static {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            ServerPlayerEntity player;
            Iterator<Map.Entry<UUID, ScheduledTeleport>> teleportIterator = activeTeleports.entrySet().iterator();
            while (teleportIterator.hasNext()) {
                Map.Entry<UUID, ScheduledTeleport> entry = teleportIterator.next();
                ScheduledTeleport task = entry.getValue();
                player = server.getPlayerManager().getPlayer(entry.getKey());
                if (player == null || player.isDisconnected()) {
                    teleportIterator.remove();
                    continue;
                }
                if (!player.getBlockPos().equals((Object)task.startPos)) {
                    player.sendMessage(task.cancelMessage, false);
                    teleportIterator.remove();
                    continue;
                }
                --task.delay;
                if (task.delay > 0) continue;
                task.action.run();
                teleportIterator.remove();
            }
            Iterator<ScheduledMessage> messageIterator = scheduledMessages.iterator();
            while (messageIterator.hasNext()) {
                ScheduledMessage message = messageIterator.next();
                --message.delay;
                if (message.delay > 0) continue;
                player = server.getPlayerManager().getPlayer(message.playerId);
                if (player != null && !player.isDisconnected()) {
                    message.action.run();
                }
                messageIterator.remove();
            }
        });
    }

    private static class ScheduledTeleport {
        int delay;
        Runnable action;
        BlockPos startPos;
        Text cancelMessage;

        ScheduledTeleport(int delay, Runnable action, BlockPos startPos, Text cancelMessage) {
            this.delay = delay;
            this.action = action;
            this.startPos = startPos;
            this.cancelMessage = cancelMessage;
        }
    }

    private static class ScheduledMessage {
        UUID playerId;
        int delay;
        Runnable action;

        ScheduledMessage(UUID playerId, int delay, Runnable action) {
            this.playerId = playerId;
            this.delay = delay;
            this.action = action;
        }
    }
}

