/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappaessentials.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import net.kappasmp.kappaessentials.economy.BalanceManager;
import net.kappasmp.kappaessentials.manager.ShopManager;
import net.kappasmp.kappaessentials.model.ShopItem;
import net.kappasmp.kappaessentials.model.ShopShop;
import net.kappasmp.kappaessentials.token.TokenManager;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class ShopSubGui
extends SimpleGui {
    public ShopSubGui(class_3222 player, String shopId) {
        super(class_3917.field_17326, player, false);
        Optional<ShopShop> optionalShop = ShopManager.getShopById(shopId);
        if (optionalShop.isEmpty()) {
            this.setTitle((class_2561)class_2561.method_43470((String)"\u00a7cShop Not Found"));
            return;
        }
        ShopShop shop = optionalShop.get();
        this.setTitle((class_2561)class_2561.method_43470((String)shop.title));
        class_1792 filler = (class_1792)class_7923.field_41178.method_63535(class_2960.method_12829((String)"minecraft:gray_stained_glass_pane"));
        for (int i = 0; i < 27; ++i) {
            this.setSlot(i, (GuiElementBuilderInterface)new GuiElementBuilder(filler).setName((class_2561)class_2561.method_43470((String)"")));
        }
        for (ShopItem item : shop.items) {
            class_2960 itemId = class_2960.method_12829((String)item.id);
            if (itemId == null || !class_7923.field_41178.method_10250(itemId)) {
                System.err.println("[Shop] Invalid item ID in config: " + item.id);
                continue;
            }
            class_1792 mcItem = (class_1792)class_7923.field_41178.method_63535(itemId);
            String name = item.customName != null && !item.customName.isEmpty() ? item.customName : "\u00a7f" + mcItem.method_63680().getString();
            ArrayList<class_5250> lore = new ArrayList<class_5250>();
            if (item.customLore != null && !item.customLore.isEmpty()) {
                for (String line : item.customLore) {
                    lore.add(class_2561.method_43470((String)line));
                }
            } else {
                lore.add(class_2561.method_43470((String)"\u00a77Click to purchase"));
                lore.add(class_2561.method_43470((String)("\u00a76" + (shop.currency.equalsIgnoreCase("tokens") ? "Token Cost" : "\ud83d\udcb0 Cost") + ": \u00a7e" + item.price)));
                lore.add(class_2561.method_43470((String)("\u00a76Amount: \u00a7e" + item.amount)));
            }
            GuiElementBuilder builder = new GuiElementBuilder(mcItem).setName((class_2561)class_2561.method_43470((String)name)).setLore(lore).setCallback((index, type, action, gui) -> this.handlePurchase(player, shop.currency, item));
            this.setSlot(item.slot, (GuiElementBuilderInterface)builder);
        }
    }

    private void handlePurchase(class_3222 player, String currency, ShopItem item) {
        boolean paid;
        UUID uuid = player.method_5667();
        boolean bl = paid = currency.equalsIgnoreCase("tokens") ? TokenManager.withdrawTokens(uuid, item.price) : BalanceManager.withdrawBalance(uuid, item.price);
        if (!paid) {
            player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7cYou do not have enough " + (currency.equalsIgnoreCase("tokens") ? "Tokens" : "Money") + ".")), false);
            return;
        }
        String command = item.customCommand != null && !item.customCommand.isEmpty() ? item.customCommand.replace("%player%", player.method_5477().getString()) : "give " + player.method_5477().getString() + " " + item.id + " " + item.amount;
        player.method_5682().method_3734().method_44252(player.method_5682().method_3739(), command);
        player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7aPurchase successful!"), false);
    }
}

