/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappaessentials.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.file.Path;
import net.kappasmp.kappaessentials.config.HomeConfig;
import net.kappasmp.kappaessentials.config.ModConfigWrapper;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static File configFile;
    private static ModConfigWrapper config;

    public static void init(Path configDir) {
        configFile = configDir.resolve("KappaEssentials/config.json").toFile();
        if (!configFile.exists()) {
            ConfigManager.save();
        }
        ConfigManager.load();
    }

    public static void load() {
        try (FileReader reader = new FileReader(configFile);){
            ModConfigWrapper loaded = (ModConfigWrapper)GSON.fromJson((Reader)reader, ModConfigWrapper.class);
            if (loaded != null && loaded.homes != null) {
                config = loaded;
                System.out.println("[KappaEssentials] Loaded config: " + GSON.toJson((Object)config));
            } else {
                System.err.println("[KappaEssentials] Failed to load config \u2014 using defaults.");
            }
        }
        catch (Exception e) {
            System.err.println("[KappaEssentials] Failed to read config.json: " + e.getMessage());
        }
    }

    public static void save() {
        try {
            configFile.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(configFile);){
                GSON.toJson((Object)config, (Appendable)writer);
            }
        }
        catch (Exception e) {
            System.err.println("[KappaEssentials] Failed to save config.json: " + e.getMessage());
        }
    }

    public static HomeConfig getHomeConfig() {
        return ConfigManager.config.homes;
    }

    static {
        config = new ModConfigWrapper();
    }
}

