/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappaessentials.gui;

import com.mojang.authlib.GameProfile;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.AnvilInputGui;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.text.NumberFormat;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kappasmp.kappaessentials.bounty.BountyManager;
import net.kappasmp.kappaessentials.economy.BalanceManager;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public class BountyGui
extends SimpleGui {
    public BountyGui(class_3222 player) {
        super(class_3917.field_17327, player, false);
        this.setTitle((class_2561)class_2561.method_43470((String)"> \u0299\u1d0f\u1d1c\u0274\u1d1b\u026a\u1d07\ua731").method_27692(class_124.field_1063));
        int slot = 0;
        Set<UUID> bountiedPlayers = BountyManager.getAllBountiedPlayers();
        if (bountiedPlayers.isEmpty()) {
            this.setSlot(22, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8077).setName((class_2561)class_2561.method_43470((String)"No bounties yet!").method_27692(class_124.field_1063)).addLoreLine((class_2561)class_2561.method_43470((String)"\u00a77Use the anvil below to add one.")));
        } else {
            List sortedBountiedPlayers = bountiedPlayers.stream().sorted((uuid1, uuid2) -> Integer.compare(BountyManager.getBounty(uuid2), BountyManager.getBounty(uuid1))).collect(Collectors.toList());
            for (UUID targetUUID : sortedBountiedPlayers) {
                String name = BountyGui.getPlayerName(player.method_5682().method_3739(), targetUUID);
                int amount = BountyManager.getBounty(targetUUID);
                String formattedAmount = BountyGui.formatMoney(amount);
                this.setSlot(slot++, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8575).setSkullOwner(targetUUID.toString()).setName((class_2561)class_2561.method_43470((String)("\u2620 " + name)).method_27692(class_124.field_1065)).addLoreLine((class_2561)class_2561.method_43470((String)("\u00a77\u0299\u1d0f\u1d1c\u0274\u1d1b\u028f: \u00a7c" + formattedAmount))).setCallback((i, t, a, gui) -> player.method_7353((class_2561)class_2561.method_43470((String)("\u1d1b\u1d00\u0280\u0262\u1d07\u1d1b: " + name + " \u029c\u1d00\u0455 \u1d00 $" + formattedAmount + " bounty.")), false)));
            }
        }
        this.setSlot(49, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8782).setName((class_2561)class_2561.method_43470((String)"\u2795 \u0455\u1d07\u1d1b \u0274\u1d07\u1d21 \u0299\u1d0f\u1d1c\u0274\u1d1b\u026a\u1d07").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067})).addLoreLine((class_2561)class_2561.method_43470((String)"\u1d04\u029f\u026a\u1d04\u1d0b \u1d1b\u1d0f \u0455\u1d07\u1d1b \u1d00 \u0299\u1d0f\u1d1c\u0274\u1d1b\u026a\u1d07 \u1d0f\u0274 \u1d00 \u1d18\u029f\u1d00\u028f\u1d07\u0280.")).setCallback((i, t, a, gui) -> {
            player.method_7346();
            new SelectBountyTargetGui(player).open();
        }));
    }

    public static String formatMoney(int amount) {
        if (amount >= 1000000000) {
            return amount / 1000000000 + "B";
        }
        if (amount >= 1000000) {
            return amount / 1000000 + "M";
        }
        if (amount >= 1000) {
            return amount / 1000 + "K";
        }
        return String.valueOf(amount);
    }

    private static String getPlayerName(class_2168 source, UUID uuid) {
        class_3222 player = source.method_9211().method_3760().method_14602(uuid);
        if (player != null) {
            return player.method_5477().getString();
        }
        Optional profile = source.method_9211().method_3793().method_14512(uuid);
        return profile.map(GameProfile::getName).orElse(uuid.toString().substring(0, 8));
    }

    public static class SelectBountyTargetGui
    extends SimpleGui {
        public SelectBountyTargetGui(class_3222 player) {
            super(class_3917.field_17327, player, false);
            this.setTitle((class_2561)class_2561.method_43470((String)"> \u0455\u1d07\u029f\u1d07\u1d04\u1d1b \u1d1b\u1d00\u0280\u0262\u1d07\u1d1b").method_27692(class_124.field_1063));
            int slot = 0;
            for (class_3222 target : player.method_5682().method_3760().method_14571()) {
                if (target.method_5667().equals(player.method_5667())) continue;
                int amount = BountyManager.getBounty(target.method_5667());
                String formattedAmount = NumberFormat.getInstance().format(amount);
                this.setSlot(slot++, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8575).setSkullOwner(target.method_5477().getString()).setName((class_2561)class_2561.method_43470((String)("\u2620 " + target.method_5477().getString())).method_27692(class_124.field_1065)).addLoreLine((class_2561)class_2561.method_43470((String)("\u00a77Bounty: \u00a7c$" + formattedAmount))).setCallback((i, t, a, gui) -> {
                    player.method_7353((class_2561)class_2561.method_43470((String)("Target: " + target.method_5477().getString() + " has a $" + formattedAmount + " bounty.")), false);
                    player.method_7346();
                    this.openAmountInput(player, target);
                }));
            }
        }

        private void openAmountInput(class_3222 source, class_3222 target) {
            AnvilInputGui inputGui = new AnvilInputGui(source, false);
            inputGui.setSlot(1, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8407).setName((class_2561)class_2561.method_43470((String)"\u00a7e\u1d07\u0274\u1d1b\u1d07\u0280 \u0299\u1d0f\u1d1c\u0274\u1d1b\u026a\u1d07\ua731 \u1d00\u1d0d\u1d0f\u1d1c\u0274\u1d1b")).addLoreLine((class_2561)class_2561.method_43470((String)"\u00a77Type an amount and click here.")).setCallback((index, type, action, gui) -> {
                String text = inputGui.getInput();
                try {
                    int amount = Integer.parseInt(text);
                    if (amount <= 0) {
                        throw new NumberFormatException();
                    }
                    if (BalanceManager.getBalance(source.method_5667()) < amount) {
                        source.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cYou don't have enough balance to set this bounty."));
                        return;
                    }
                    BountyManager.setBounty(target.method_5667(), source.method_5667(), amount);
                    BalanceManager.addBalance(source.method_5667(), -amount);
                    source.method_64398((class_2561)class_2561.method_43470((String)("\u00a7a\u0299\u1d0f\u1d1c\u0274\u1d1b\u028f \u0455\u1d07\u1d1b \u1d0f\u0274 \u00a7e" + target.method_5477().getString() + " \u00a7afor \u00a7c$" + BountyGui.formatMoney(amount))));
                }
                catch (NumberFormatException e) {
                    source.method_64398((class_2561)class_2561.method_43470((String)"\u00a7c\u026a\u0274\u1d20\u1d00\u029f\u026a\u1d05 \u0299\u1d0f\u1d1c\u0274\u1d1b\u028f \u1d00\u1d0d\u1d0f\u1d1c\u0274\u1d1b."));
                }
                gui.close();
            }));
            inputGui.open();
        }
    }
}

