/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappaessentials.teleport;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2709;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class HomeTeleportScheduler {
    private static final List<TeleportTask> tasks = new ArrayList<TeleportTask>();

    public static void tick(MinecraftServer server) {
        Iterator<TeleportTask> iterator = tasks.iterator();
        while (iterator.hasNext()) {
            TeleportTask task = iterator.next();
            if (!task.player.method_24515().equals((Object)task.startPos)) {
                task.player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cYou moved! Teleportation cancelled."), false);
                iterator.remove();
                continue;
            }
            if (task.delayTicks == 0) {
                class_3218 targetWorld = server.method_3847(task.dimension);
                if (targetWorld == null) {
                    task.player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cError: world not found!"), false);
                    iterator.remove();
                    continue;
                }
                task.player.method_48105(targetWorld, (double)task.pos.method_10263() + 0.5, (double)task.pos.method_10264(), (double)task.pos.method_10260() + 0.5, EnumSet.noneOf(class_2709.class), task.player.method_36454(), task.player.method_36455(), false);
                task.player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7aTeleported to home '" + task.name + "'!")), false);
                iterator.remove();
                continue;
            }
            if (task.delayTicks % 20 == 0) {
                int secondsLeft = task.delayTicks / 20;
                task.player.method_7353((class_2561)class_2561.method_43470((String)("\u00a77Teleporting in " + secondsLeft + "...")), false);
            }
            --task.delayTicks;
        }
    }

    public static void queue(class_3222 player, class_2338 pos, class_5321<class_1937> dimension, String name) {
        tasks.add(new TeleportTask(player, pos, dimension, name));
    }

    private static class TeleportTask {
        class_3222 player;
        class_2338 pos;
        class_5321<class_1937> dimension;
        String name;
        int delayTicks = 100;
        class_2338 startPos;

        TeleportTask(class_3222 player, class_2338 pos, class_5321<class_1937> dimension, String name) {
            this.player = player;
            this.pos = pos;
            this.dimension = dimension;
            this.name = name;
            this.startPos = player.method_24515();
        }
    }
}

