/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappaessentials.economy;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import java.util.UUID;
import net.kappasmp.kappaessentials.economy.BalanceManager;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class BalCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"bal").executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            return BalCommand.showBalance(source, source.method_44023().method_5667(), source.method_9214());
        })).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String playerName = StringArgumentType.getString((CommandContext)context, (String)"player");
            class_2168 source = (class_2168)context.getSource();
            class_3222 onlinePlayer = source.method_9211().method_3760().method_14566(playerName);
            if (onlinePlayer != null) {
                return BalCommand.showBalance(source, onlinePlayer.method_5667(), onlinePlayer.method_5477().getString());
            }
            Optional profile = source.method_9211().method_3793().method_14515(playerName);
            if (profile.isPresent()) {
                UUID uuid = ((GameProfile)profile.get()).getId();
                return BalCommand.showBalance(source, uuid, playerName);
            }
            source.method_9226(() -> class_2561.method_43470((String)"Player not found."), false);
            return 0;
        })));
    }

    private static int showBalance(class_2168 source, UUID uuid, String name) {
        int balance = BalanceManager.getBalance(uuid);
        String formattedBalance = BalCommand.formatBalance(balance);
        class_5250 message = class_2561.method_43470((String)"Balance of ").method_10862(class_2583.field_24360.method_36139(0xBEBEBE)).method_10852((class_2561)class_2561.method_43470((String)name).method_10862(class_2583.field_24360.method_36139(16745216))).method_10852((class_2561)class_2561.method_43470((String)" is ").method_10862(class_2583.field_24360.method_36139(0xBEBEBE))).method_10852((class_2561)class_2561.method_43470((String)("$" + formattedBalance)).method_10862(class_2583.field_24360.method_36139(16745216)));
        source.method_9226(() -> message, false);
        return 1;
    }

    private static String formatBalance(int balance) {
        if (balance >= 1000000000) {
            return String.format("%.1fB", (double)balance / 1.0E9);
        }
        if (balance >= 1000000) {
            return String.format("%.1fM", (double)balance / 1000000.0);
        }
        if (balance >= 1000) {
            return String.format("%.1fK", (double)balance / 1000.0);
        }
        return String.format("%d", balance);
    }
}

