/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappaessentials.economy;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class BalanceManager {
    private static final Map<UUID, Integer> playerBalances = new HashMap<UUID, Integer>();
    private static final Map<String, Integer> itemPrices = new HashMap<String, Integer>();
    private static File balanceFile;
    private static File priceFile;
    private static final Gson gson;

    public static void init(MinecraftServer server) {
        Path dataDir = server.method_3831().resolve("config/Kappaessentials");
        balanceFile = dataDir.resolve("balance.json").toFile();
        priceFile = dataDir.resolve("prices.json").toFile();
        if (!dataDir.toFile().exists()) {
            dataDir.toFile().mkdirs();
        }
        BalanceManager.loadBalances();
        BalanceManager.loadItemPrices();
    }

    public static void loadBalances() {
        if (balanceFile.exists()) {
            try (FileReader reader = new FileReader(balanceFile);){
                JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                playerBalances.clear();
                for (Map.Entry entry : json.entrySet()) {
                    playerBalances.put(UUID.fromString((String)entry.getKey()), ((JsonElement)entry.getValue()).getAsInt());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void loadItemPrices() {
        if (priceFile.exists()) {
            try (FileReader reader = new FileReader(priceFile);){
                JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                itemPrices.clear();
                for (Map.Entry entry : json.entrySet()) {
                    itemPrices.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            BalanceManager.initializeDefaultItemPrices();
        }
    }

    public static void saveBalances() {
        try (FileWriter writer = new FileWriter(balanceFile);){
            JsonObject json = new JsonObject();
            playerBalances.forEach((uuid, balance) -> json.addProperty(uuid.toString(), (Number)balance));
            gson.toJson((JsonElement)json, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void savePlayerBalance(class_3222 player) {
        UUID uuid = player.method_5667();
        int balance = BalanceManager.getBalance(uuid);
        try (FileReader reader = new FileReader(balanceFile);){
            JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            json.addProperty(uuid.toString(), (Number)balance);
            try (FileWriter writer = new FileWriter(balanceFile);){
                gson.toJson((JsonElement)json, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveItemPrices() {
        try (FileWriter writer = new FileWriter(priceFile);){
            JsonObject json = new JsonObject();
            itemPrices.forEach((arg_0, arg_1) -> ((JsonObject)json).addProperty(arg_0, arg_1));
            gson.toJson((JsonElement)json, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int getBalance(UUID uuid) {
        return playerBalances.getOrDefault(uuid, 0);
    }

    public static void setBalance(UUID uuid, int amount) {
        playerBalances.put(uuid, amount);
        BalanceManager.saveBalances();
    }

    public static void addBalance(UUID uuid, int amount) {
        BalanceManager.setBalance(uuid, BalanceManager.getBalance(uuid) + amount);
    }

    public static void subtractBalance(UUID uuid, int amount) {
        BalanceManager.setBalance(uuid, BalanceManager.getBalance(uuid) - amount);
    }

    public static int getItemPrice(String itemId) {
        return itemPrices.getOrDefault(itemId, 0);
    }

    public static void setItemPrice(String itemId, int price) {
        itemPrices.put(itemId, price);
        BalanceManager.saveItemPrices();
    }

    public static void reloadBalances() {
        BalanceManager.loadBalances();
    }

    public static void reloadPrices() {
        BalanceManager.loadItemPrices();
    }

    private static void initializeDefaultItemPrices() {
        BalanceManager.setItemPrice("minecraft:stone", 1);
        BalanceManager.setItemPrice("minecraft:diamond", 15);
        BalanceManager.setItemPrice("minecraft:iron_ore", 5);
    }

    public static boolean withdrawBalance(UUID playerUUID, int amount) {
        int balance = BalanceManager.getBalance(playerUUID);
        if (balance >= amount) {
            BalanceManager.setBalance(playerUUID, balance - amount);
            return true;
        }
        return false;
    }

    public static List<Map.Entry<UUID, Integer>> getTopBalances(int limit) {
        return playerBalances.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(limit).collect(Collectors.toList());
    }

    static {
        gson = new GsonBuilder().setPrettyPrinting().create();
    }
}

