/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappaessentials.manager;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import net.kappasmp.kappaessentials.model.ShopCategory;
import net.kappasmp.kappaessentials.model.ShopConfig;
import net.kappasmp.kappaessentials.model.ShopShop;

public class ShopManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static ShopConfig shopConfig = new ShopConfig();
    private static File shopFile;
    private static final String DEFAULT_JSON = "        // Welcome to the Kappaessentials shop.json file!\n                                                   {\n                                                                           \"mainMenu\": [ \n                                                                             {\n                                                                               \"name\": \"\u00a7c\u1d18\u1d20\u1d18 \u0455\u029c\u1d0f\u1d18\",\n                                                                               \"icon\": \"minecraft:totem_of_undying\",\n                                                                               \"slot\": 11,\n                                                                               \"shopId\": \"pvp\" // use shopId to reference what it will open when clicked on\n                                                                             },\n                                                                             {\n                                                                               \"name\": \"\u00a76\ua730\u1d0f\u1d0f\u1d05 \u0455\u029c\u1d0f\u1d18\",\n                                                                               \"icon\": \"minecraft:cooked_beef\",\n                                                                               \"slot\": 12,\n                                                                               \"shopId\": \"food\"\n                                                                             },\n                                                                             {\n                                                                               \"name\": \"\u00a7d\u1d07\u0274\u1d05 \u0455\u029c\u1d0f\u1d18\",\n                                                                               \"icon\": \"minecraft:ender_pearl\",\n                                                                               \"slot\": 13,\n                                                                               \"shopId\": \"end\"\n                                                                             },\n                                                                             {\n                                                                               \"name\": \"\u00a74\u0274\u1d07\u1d1b\u029c\u1d07\u0280 \u0455\u029c\u1d0f\u1d18\",\n                                                                               \"icon\": \"minecraft:netherrack\",\n                                                                               \"slot\": 14,\n                                                                               \"shopId\": \"nether\"\n                                                                             },\n                                                                             {\n                                                                               \"name\": \"\u00a75\u1d1b\u1d0f\u1d0b\u1d07\u0274 \u0455\u029c\u1d0f\u1d18\",\n                                                                               \"icon\": \"minecraft:amethyst_shard\",\n                                                                               \"slot\": 15,\n                                                                               \"shopId\": \"token\"\n                                                                             }\n                                                                           ],\n                                                                           \"shops\": [\n                                                                             {\n                                                                               \"id\": \"pvp\",\n                                                                               \"title\": \"\u00a77> \u1d18\u1d20\u1d18 \u0455\u029c\u1d0f\u1d18\",\n                                                                               \"currency\": \"coins\", // you can chose for either \"coins\" or \"tokens\", depends what currency you want to use\n                                                                               \"items\": [\n                                                                                 {\n                                                                                   \"slot\": 10, // displays what slot any item has, so where it should be\n                                                                                   \"id\": \"minecraft:totem_of_undying\",\n                                                                                   \"price\": 1250,\n                                                                                   \"customName\": \"\u00a76Totem of Undying\",\n                                                                                   \"customCommand\": \"/give %player% minecraft:totem_of_undying 1\", // use any number you have specified in amount, and reference it after the Id\n                                                                                   \"amount\": 1 //use amount for what amount it displays on screen\n                                                                                 },\n                                                                                 {\n                                                                                   \"slot\": 11,\n                                                                                   \"id\": \"minecraft:end_crystal\",\n                                                                                   \"price\": 900,\n                                                                                   \"customName\": \"\u00a76End Crystal\",\n                                                                                   \"customCommand\": \"/give %player% minecraft:end_crystal 16\",\n                                                                                   \"amount\": 16\n                                                                                 },\n                                                                                 {\n                                                                                   \"slot\": 12,\n                                                                                   \"id\": \"minecraft:obsidian\",\n                                                                                   \"price\": 550,\n                                                                                   \"customName\": \"\u00a76Obsidian\",\n                                                                                   \"customCommand\": \"/give %player% minecraft:obsidian 64\",\n                                                                                   \"amount\": 64\n                                                                                 },\n                                                                                 {\n                                                                                   \"slot\": 13,\n                                                                                   \"id\": \"minecraft:respawn_anchor\",\n                                                                                   \"price\": 1100,\n                                                                                   \"customName\": \"\u00a76Respawn Anchor\",\n                                                                                   \"customCommand\": \"/give %player% minecraft:respawn_anchor 4\",\n                                                                                   \"amount\": 4\n                                                                                 },\n                                                                                 {\n                                                                                   \"slot\": 14,\n                                                                                   \"id\": \"minecraft:glowstone\",\n                                                                                   \"price\": 900,\n                                                                                   \"customName\": \"\u00a76Glowstone\",\n                                                                                   \"customCommand\": \"/give %player% minecraft:glowstone 32\",\n                                                                                   \"amount\": 32\n                                                                                 },\n                                                                                 {\n                                                                                   \"slot\": 15,\n                                                                                   \"id\": \"minecraft:golden_apple\",\n                                                                                   \"price\": 900,\n                                                                                   \"customName\": \"\u00a76Golden Apple\",\n                                                                                   \"customCommand\": \"/give %player% minecraft:golden_apple 8\",\n                                                                                   \"amount\": 8\n                                                                                 },\n                                                                                 {\n                                                                                   \"slot\": 16,\n                                                                                   \"id\": \"minecraft:ender_pearl\",\n                                                                                   \"price\": 200,\n                                                                                   \"customName\": \"\u00a76Ender Pearl\",\n                                                                                   \"customCommand\": \"/give %player% minecraft:ender_pearl 16\",\n                                                                                   \"amount\": 16\n                                                                                 }\n                                                                               ]\n                                                                             },\n                                                                             {\n                                                                               \"id\": \"food\",\n                                                                               \"title\": \"\u00a77> \ua730\u1d0f\u1d0f\u1d05 \u0455\u029c\u1d0f\u1d18\",\n                                                                               \"currency\": \"coins\",\n                                                                               \"items\": [\n                                                                                 {\n                                                                                   \"slot\": 11,\n                                                                                   \"id\": \"minecraft:cooked_beef\",\n                                                                                   \"price\": 100,\n                                                                                   \"customName\": \"\u00a76Cooked Beef\",\n                                                                                   \"customCommand\": \"/give %player% minecraft:cooked_beef 32\",\n                                                                                   \"amount\": 32\n                                                                                 },\n                                                                                 {\n                                                                                   \"slot\": 12,\n                                                                                   \"id\": \"minecraft:cooked_chicken\",\n                                                                                   \"price\": 900,\n                                                                                   \"customName\": \"\u00a76Cooked Chicken\",\n                                                                                   \"customCommand\": \"/give %player% minecraft:cooked_chicken 16\",\n                                                                                   \"amount\": 16\n                                                                                 },\n                                                                                 {\n                                                                                   \"slot\": 13,\n                                                                                   \"id\": \"minecraft:golden_apple\",\n                                                                                   \"price\": 900,\n                                                                                   \"customName\": \"\u00a76Golden Apple\",\n                                                                                   \"customCommand\": \"/give %player% minecraft:golden_apple 8\",\n                                                                                   \"amount\": 8\n                                                                                 },\n                                                                                 {\n                                                                                   \"slot\": 14,\n                                                                                   \"id\": \"minecraft:golden_carrot\",\n                                                                                   \"price\": 50,\n                                                                                   \"customName\": \"\u00a76Golden Carrot\",\n                                                                                   \"customCommand\": \"/give %player% minecraft:golden_carrot 4\",\n                                                                                   \"amount\": 4\n                                                                                 },\n                                                                                 {\n                                                                                   \"slot\": 15,\n                                                                                   \"id\": \"minecraft:cooked_porkchop\",\n                                                                                   \"price\": 100,\n                                                                                   \"customName\": \"\u00a76Cooked Porkchop\",\n                                                                                   \"customCommand\": \"/give %player% minecraft:cooked_porkchop 32\",\n                                                                                   \"amount\": 32\n                                                                                 }\n                                                                               ]\n                                                                             },\n                                                                             {\n                                                                               \"id\": \"end\",\n                                                                               \"title\": \"\u00a77> \u1d07\u0274\u1d05 \u0455\u029c\u1d0f\u1d18\",\n                                                                               \"currency\": \"coins\",\n                                                                               \"items\": [\n                                                                                 {\n                                                                                   \"slot\": 11,\n                                                                                   \"id\": \"minecraft:ender_pearl\",\n                                                                                   \"price\": 200,\n                                                                                   \"customName\": \"\u00a76Ender Pearl\",\n                                                                                   \"customCommand\": \"/give %player% minecraft:ender_pearl 16\",\n                                                                                   \"amount\": 16\n                                                                                 },\n                                                                                 {\n                                                                                   \"slot\": 12,\n                                                                                   \"id\": \"minecraft:ender_chest\",\n                                                                                   \"price\": 900,\n                                                                                   \"customName\": \"\u00a76Ender Chest\",\n                                                                                   \"customCommand\": \"/give %player% minecraft:ender_chest 16\",\n                                                                                   \"amount\": 16\n                                                                                 },\n                                                                                 {\n                                                                                   \"slot\": 13,\n                                                                                   \"id\": \"minecraft:shulker_box\",\n                                                                                   \"price\": 750,\n                                                                                   \"customName\": \"\u00a76Shulker Box\",\n                                                                                   \"customCommand\": \"/give %player% minecraft:shulker_box 1\",\n                                                                                   \"amount\": 1\n                                                                                 },\n                                                                                 {\n                                                                                   \"slot\": 14,\n                                                                                   \"id\": \"minecraft:firework_rocket\",\n                                                                                   \"price\": 1000,\n                                                                                   \"customName\": \"\u00a76Firework Rocket\",\n                                                                                   \"customCommand\": \"/give %player% minecraft:firework_rocket 32\",\n                                                                                   \"amount\": 32\n                                                                                 },\n                                                                                 {\n                                                                                   \"slot\": 15,\n                                                                                   \"id\": \"minecraft:elytra\",\n                                                                                   \"price\": 300000,\n                                                                                   \"customName\": \"\u00a76Elytra\",\n                                                                                   \"customCommand\": \"/give %player% minecraft:elytra 1\",\n                                                                                   \"amount\": 1\n                                                                                 }\n                                                                               ]\n                                                                             },\n                                                                             {\n                                                                               \"id\": \"nether\",\n                                                                               \"title\": \"\u00a77> \u0274\u1d07\u1d1b\u029c\u1d07\u0280 \u0455\u029c\u1d0f\u1d18\",\n                                                                               \"currency\": \"coins\",\n                                                                               \"items\": [\n                                                                                 {\n                                                                                   \"slot\": 11,\n                                                                                   \"id\": \"minecraft:netherrack\",\n                                                                                   \"price\": 200,\n                                                                                   \"customName\": \"\u00a76Netherrack\",\n                                                                                   \"customCommand\": \"/give %player% minecraft:netherrack 32\",\n                                                                                   \"amount\": 32\n                                                                                 },\n                                                                                 {\n                                                                                   \"slot\": 12,\n                                                                                   \"id\": \"minecraft:glowstone\",\n                                                                                   \"price\": 900,\n                                                                                   \"customName\": \"\u00a76Glowstone\",\n                                                                                   \"customCommand\": \"/give %player% minecraft:glowstone 32\",\n                                                                                   \"amount\": 32\n                                                                                 },\n                                                                                 {\n                                                                                   \"slot\": 13,\n                                                                                   \"id\": \"minecraft:quartz\",\n                                                                                   \"price\": 750,\n                                                                                   \"customName\": \"\u00a76Quartz\",\n                                                                                   \"customCommand\": \"/give %player% minecraft:quartz 32\",\n                                                                                   \"amount\": 32\n                                                                                 },\n                                                                                 {\n                                                                                   \"slot\": 14,\n                                                                                   \"id\": \"minecraft:magma_cream\",\n                                                                                   \"price\": 1000,\n                                                                                   \"customName\": \"\u00a76Magma Cream\",\n                                                                                   \"customCommand\": \"/give %player% minecraft:magma_cream 1\",\n                                                                                   \"amount\": 1\n                                                                                 },\n                                                                                 {\n                                                                                   \"slot\": 15,\n                                                                                   \"id\": \"minecraft:magma_block\",\n                                                                                   \"price\": 550,\n                                                                                   \"customName\": \"\u00a76Magma Block\",\n                                                                                   \"customCommand\": \"/give %player% minecraft:magma_block 32\",\n                                                                                   \"amount\": 32\n                                                                                 }\n                                                                               ]\n                                                                             },\n                                                                             {\n                                                                               \"id\": \"token\",\n                                                                               \"title\": \"\u00a77> \u1d1b\u1d0f\u1d0b\u1d07\u0274 \u0455\u029c\u1d0f\u1d18\",\n                                                                               \"currency\": \"tokens\",\n                                                                               \"items\": [\n                                                                                 {\n                                                                                   \"slot\": 11,\n                                                                                   \"id\": \"minecraft:spawner\",\n                                                                                   \"price\": 200,\n                                                                                   \"customName\": \"\u00a75Creeper Spawner\",\n                                                                                   \"customCommand\": \"/give %player% spawner[block_entity_data={id:\\\"mob_spawner\\\",SpawnData:{entity:{id:\\\"minecraft:creeper\\\"}}}] 1\", // This give command is not necesary (with the \\ and whatnot), use any command that works via console\n                                                                                   \"amount\": 1\n                                                                                 },\n                                                                                 {\n                                                                                   \"slot\": 12,\n                                                                                   \"id\": \"minecraft:spawner\",\n                                                                                   \"price\": 150,\n                                                                                   \"customName\": \"\u00a75Zombie Spawner\",\n                                                                                   \"customCommand\": \"/give %player% spawner[block_entity_data={id:\\\"mob_spawner\\\",SpawnData:{entity:{id:\\\"minecraft:zombie\\\"}}}] 1\",\n                                                                                   \"amount\": 1\n                                                                                 },\n                                                                                 {\n                                                                                   \"slot\": 13,\n                                                                                   \"id\": \"minecraft:spawner\",\n                                                                                   \"price\": 400,\n                                                                                   \"customName\": \"\u00a75Skeleton Spawner\",\n                                                                                   \"customCommand\": \"/give %player% spawner[block_entity_data={id:\\\"mob_spawner\\\",SpawnData:{entity:{id:\\\"minecraft:skeleton\\\"}}}] 1\",\n                                                                                   \"amount\": 1\n                                                                                 },\n                                                                                 {\n                                                                                   \"slot\": 14,\n                                                                                   \"id\": \"minecraft:spawner\",\n                                                                                   \"price\": 50,\n                                                                                   \"customName\": \"\u00a75Cow Spawner\",\n                                                                                   \"customCommand\": \"/give %player% spawner[block_entity_data={id:\\\"mob_spawner\\\",SpawnData:{entity:{id:\\\"minecraft:cow\\\"}}}] 1\",\n                                                                                   \"amount\": 1\n                                                                                 },\n                                                                                 {\n                                                                                   \"slot\": 15,\n                                                                                   \"id\": \"minecraft:spawner\",\n                                                                                   \"price\": 1250,\n                                                                                   \"customName\": \"\u00a75Iron Golem Spawner\",\n                                                                                   \"customCommand\": \"/give %player% spawner[block_entity_data={id:\\\"mob_spawner\\\",SpawnData:{entity:{id:\\\"minecraft:iron_golem\\\"}}}] 1\",\n                                                                                   \"amount\": 1\n                                                                                 },\n                                                                                 {\n                                                                                   \"slot\": 4,\n                                                                                   \"id\": \"minecraft:netherite_sword\",\n                                                                                   \"price\": 2000,\n                                                                                   \"customName\": \"\u00a75\u1d1b\u029c\u1d07 \u1d22\u1d07\u0274\u026a\u1d1b\u029c\",\n                                                                                   \"customCommand\": \"/give %player% netherite_sword[custom_name='[{\\\"text\\\":\\\"\u1d1b\u029c\u1d07 \u1d22\u1d07\u0274\u026a\u1d1b\u029c\\\",\\\"italic\\\":false,\\\"color\\\":\\\"dark_purple\\\",\\\"bold\\\":true}]',rarity=epic,enchantments={levels:{bane_of_arthropods:5,knockback:2,looting:5,mending:1,sharpness:10,unbreaking:5,silk_touch:1,smite:5,sweeping_edge:5}}]\",\n                                                                                   \"customLore\": [\n                                                                                                         \"\u00a77Click to purchase\",\n                                                                                                         \"\u00a7bEnchantments:\",\n                                                                                                         \"\u00a77\u2022 Sharpness X\",\n                                                                                                         \"\u00a77\u2022 Smite V\",\n                                                                                                         \"\u00a77\u2022 Bane of Arthropods V\",\n                                                                                                         \"\u00a77\u2022 Sweeping Edge V\",\n                                                                                                         \"\u00a77\u2022 Knockback II\",\n                                                                                                         \"\u00a77\u2022 Looting V\",\n                                                                                                         \"\u00a77\u2022 Silk Touch\",\n                                                                                                         \"\u00a77\u2022 Unbreaking V\",\n                                                                                                         \"\u00a77\u2022 Mending\",\n                                                                                                         \"\u00a76Token Cost: \u00a7e2000\"\n                                                                                                       ],\n                                                                                   \"amount\": 1\n                                                                                 },\n                                                                                 {\n                                                                                   \"slot\": 5,\n                                                                                   \"id\": \"minecraft:netherite_axe\",\n                                                                                   \"price\": 1000,\n                                                                                   \"customName\": \"\u00a76\u029f\u1d07\u0262\u1d07\u0274\u1d05\u1d00\u0280\u028f \u1d00\u0445\u1d07\",\n                                                                                   \"customCommand\": \"/give %player% netherite_axe[custom_name='[{\\\"text\\\":\\\"\u029f\u1d07\u0262\u1d07\u0274\u1d05\u1d00\u0280\u028f \u1d00\u0445\u1d07\\\",\\\"italic\\\":false,\\\"color\\\":\\\"gold\\\",\\\"bold\\\":true}]',rarity=epic,enchantments={levels:{bane_of_arthropods:5,efficiency:7,knockback:2,mending:1,sharpness:10,silk_touch:1,unbreaking:5,smite:5}}]\",\n                                                                                   \"customLore\": [\n                                                                                             \"\u00a77Click to purchase\",\n                                                                                             \"\u00a7bEnchantments:\",\n                                                                                             \"\u00a77\u2022 Sharpness X\",\n                                                                                             \"\u00a77\u2022 Smite V\",\n                                                                                             \"\u00a77\u2022 Bane of Arthropods V\",\n                                                                                             \"\u00a77\u2022 Knockback II\",\n                                                                                             \"\u00a77\u2022 Efficiency VII\",\n                                                                                             \"\u00a77\u2022 Silk Touch\",\n                                                                                             \"\u00a77\u2022 Unbreaking V\",\n                                                                                             \"\u00a77\u2022 Mending\",\n                                                                                             \"\u00a76Token Cost: \u00a7e1000\"\n                                                                                           ],\n                                                                                   \"amount\": 1\n                                                                                 },\n                                                                                 {\n                                                                                   \"slot\": 3,\n                                                                                   \"id\": \"minecraft:netherite_pickaxe\",\n                                                                                   \"price\": 1000,\n                                                                                   \"customName\": \"\u00a76\u029f\u1d07\u0262\u1d07\u0274\u1d05\u1d00\u0280\u028f \u1d18\u026a\u1d04\u1d0b\u1d00\u0445\u1d07\",\n                                                                                   \"customCommand\": \"/give %player% netherite_pickaxe[custom_name='[{\\\"text\\\":\\\"\u029f\u1d07\u0262\u1d07\u0274\u1d05\u1d00\u0280\u028f \u1d18\u026a\u1d04\u1d0b\u1d00\u0445\u1d07\\\",\\\"italic\\\":false,\\\"color\\\":\\\"gold\\\",\\\"bold\\\":true}]',rarity=epic,enchantments={levels:{efficiency:8,fortune:5,mending:1,unbreaking:6}}]\",\n                                                                                   \"customLore\": [\n                                                                                             \"\u00a77Click to purchase\",\n                                                                                             \"\u00a7bEnchantments:\",\n                                                                                             \"\u00a77\u2022 Efficiency VIII\",\n                                                                                             \"\u00a77\u2022 Fortune V\",\n                                                                                             \"\u00a77\u2022 Unbreaking VI\",\n                                                                                             \"\u00a77\u2022 Mending\",\n                                                                                             \"\u00a76Token Cost: \u00a7e1000\"\n                                                                                           ],\n                                                                                   \"amount\": 1\n                                                                                 }\n                                                                               ]\n                                                                             }\n                                                                           ]\n                                                                         }\n";

    public static void init(Path configDir) {
        File configFolder = configDir.resolve("Kappaessentials").toFile();
        configFolder.mkdirs();
        shopFile = new File(configFolder, "shop.json");
        if (!shopFile.exists()) {
            ShopManager.saveDefaultShop();
        }
        ShopManager.loadShop();
    }

    public static void loadShop() {
        try (FileReader reader = new FileReader(shopFile);){
            shopConfig = (ShopConfig)GSON.fromJson((Reader)reader, ShopConfig.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveDefaultShop() {
        try (FileWriter writer = new FileWriter(shopFile);){
            writer.write(DEFAULT_JSON);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveShop() {
        try (FileWriter writer = new FileWriter(shopFile);){
            GSON.toJson((Object)shopConfig, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<ShopCategory> getMainMenu() {
        return ShopManager.shopConfig.mainMenu;
    }

    public static Optional<ShopShop> getShopById(String id) {
        if (ShopManager.shopConfig.shops == null) {
            return Optional.empty();
        }
        return ShopManager.shopConfig.shops.stream().filter(shop -> shop.id.equalsIgnoreCase(id)).findFirst();
    }

    public static int getShopCount() {
        return ShopManager.shopConfig.shops != null ? ShopManager.shopConfig.shops.size() : 0;
    }
}

