/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappaessentials.token;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public class TokenManager {
    private static final Map<UUID, Integer> tokenMap = new HashMap<UUID, Integer>();
    private static final Gson gson = new Gson();
    private static final File directory = new File("config/Kappaessentials");
    private static final File file = new File(directory, "tokens.json");

    public static int getTokens(UUID uuid) {
        return tokenMap.getOrDefault(uuid, 0);
    }

    public static void addTokens(UUID uuid, int amount) {
        tokenMap.put(uuid, TokenManager.getTokens(uuid) + amount);
        TokenManager.save();
    }

    public static void giveTokens(UUID uuid, int amount) {
        TokenManager.addTokens(uuid, amount);
    }

    public static boolean withdrawTokens(UUID uuid, int amount) {
        int current = TokenManager.getTokens(uuid);
        if (current >= amount) {
            tokenMap.put(uuid, current - amount);
            TokenManager.save();
            return true;
        }
        return false;
    }

    public static List<Map.Entry<UUID, Integer>> getTopTokens(int amount) {
        return tokenMap.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(amount).collect(Collectors.toList());
    }

    public static void load() {
        if (!file.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(file);){
            Type type = new TypeToken<Map<String, Integer>>(){}.getType();
            Map rawMap = (Map)gson.fromJson((Reader)reader, type);
            tokenMap.clear();
            for (Map.Entry entry : rawMap.entrySet()) {
                tokenMap.put(UUID.fromString((String)entry.getKey()), (Integer)entry.getValue());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        HashMap<String, Integer> rawMap = new HashMap<String, Integer>();
        for (Map.Entry<UUID, Integer> entry : tokenMap.entrySet()) {
            rawMap.put(entry.getKey().toString(), entry.getValue());
        }
        try (FileWriter writer = new FileWriter(file);){
            gson.toJson(rawMap, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

