/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappaessentials;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import java.nio.file.Path;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.kappasmp.kappaessentials.bounty.BountyCommand;
import net.kappasmp.kappaessentials.bounty.BountyManager;
import net.kappasmp.kappaessentials.command.AfkCommand;
import net.kappasmp.kappaessentials.command.BalTopCommand;
import net.kappasmp.kappaessentials.command.ReloadCommand;
import net.kappasmp.kappaessentials.config.ConfigManager;
import net.kappasmp.kappaessentials.economy.BalCommand;
import net.kappasmp.kappaessentials.economy.BalanceManager;
import net.kappasmp.kappaessentials.economy.PayCommand;
import net.kappasmp.kappaessentials.economy.SellCommand;
import net.kappasmp.kappaessentials.gui.ShopGui;
import net.kappasmp.kappaessentials.homes.HomeCommand;
import net.kappasmp.kappaessentials.homes.HomeManager;
import net.kappasmp.kappaessentials.manager.ShopManager;
import net.kappasmp.kappaessentials.teleport.HomeTeleportScheduler;
import net.kappasmp.kappaessentials.teleport.TpAcceptCommand;
import net.kappasmp.kappaessentials.teleport.TpDenyCommand;
import net.kappasmp.kappaessentials.teleport.TpaCommand;
import net.kappasmp.kappaessentials.teleport.TpahereCommand;
import net.kappasmp.kappaessentials.token.TokenManager;
import net.kappasmp.kappaessentials.token.TokenTopCommand;
import net.kappasmp.kappaessentials.token.TokensCommand;
import net.kappasmp.kappaessentials.update.ModUpdateChecker;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class Kappaessentials
implements ModInitializer {
    public static final String MOD_ID = "kappaessentials";
    private static MinecraftServer serverInstance;

    public void onInitialize() {
        this.registerCommands();
        ServerLifecycleEvents.SERVER_STARTED.register(this::onServerStart);
        ServerLifecycleEvents.SERVER_STOPPING.register(this::onServerStop);
        Kappaessentials.log("Mod initialized.");
        BountyManager.loadBounties();
        HomeManager.loadHomes();
        ServerTickEvents.END_SERVER_TICK.register(HomeTeleportScheduler::tick);
        ConfigManager.init(FabricLoader.getInstance().getConfigDir());
        System.out.println("[KappaEssentials] Initialized with config:");
        System.out.println(ConfigManager.getHomeConfig());
        ModUpdateChecker.checkForUpdates("1.0.0-1.21");
    }

    private void registerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            BalCommand.register((CommandDispatcher<class_2168>)dispatcher);
            SellCommand.register((CommandDispatcher<class_2168>)dispatcher);
            ReloadCommand.register((CommandDispatcher<class_2168>)dispatcher);
            AfkCommand.register((CommandDispatcher<class_2168>)dispatcher);
            TokensCommand.register((CommandDispatcher<class_2168>)dispatcher);
            TokenTopCommand.register((CommandDispatcher<class_2168>)dispatcher);
            BalTopCommand.register((CommandDispatcher<class_2168>)dispatcher);
            PayCommand.register((CommandDispatcher<class_2168>)dispatcher);
            BountyCommand.register((CommandDispatcher<class_2168>)dispatcher);
            HomeCommand.register((CommandDispatcher<class_2168>)dispatcher);
            TpaCommand.register((CommandDispatcher<class_2168>)dispatcher);
            TpahereCommand.register((CommandDispatcher<class_2168>)dispatcher);
            TpAcceptCommand.register((CommandDispatcher<class_2168>)dispatcher);
            TpDenyCommand.register((CommandDispatcher<class_2168>)dispatcher);
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"shop").requires(source -> source.method_9259(0))).executes(context -> {
                class_3222 player = ((class_2168)context.getSource()).method_44023();
                new ShopGui(player).open();
                return 1;
            }));
            ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
                class_3222 player = handler.field_14140;
                if (player.method_5687(2)) {
                    ModUpdateChecker.notifyIfOutdated(player, "1.1.5");
                }
            });
        });
    }

    private void onServerStart(MinecraftServer server) {
        serverInstance = server;
        Path configDir = FabricLoader.getInstance().getConfigDir();
        BalanceManager.init(server);
        TokenManager.load();
        ShopManager.init(configDir);
        this.registerPlaceholders();
        Kappaessentials.log("Balances, tokens, and shop loaded.");
    }

    private void onServerStop(MinecraftServer server) {
        BalanceManager.saveBalances();
        TokenManager.save();
        ShopManager.saveShop();
        Kappaessentials.log("Balances, tokens, and shop saved.");
    }

    public static MinecraftServer getServerInstance() {
        return serverInstance;
    }

    public static void onPlayerLeave(class_3222 player) {
        BalanceManager.savePlayerBalance(player);
    }

    public static void log(String message) {
        System.out.println("[kappaessentials] " + message);
    }

    private void registerPlaceholders() {
        Placeholders.register((class_2960)class_2960.method_60655((String)MOD_ID, (String)"bal"), this::balancePlaceholder);
        Placeholders.register((class_2960)class_2960.method_60655((String)MOD_ID, (String)"tokens"), this::tokensPlaceholder);
    }

    private PlaceholderResult balancePlaceholder(PlaceholderContext ctx, String arg) {
        if (!ctx.hasPlayer()) {
            return PlaceholderResult.invalid((String)"No player context");
        }
        double balance = BalanceManager.getBalance(ctx.player().method_5667());
        return PlaceholderResult.value((class_2561)class_2561.method_43470((String)this.formatBalance(balance)));
    }

    private PlaceholderResult tokensPlaceholder(PlaceholderContext ctx, String arg) {
        if (!ctx.hasPlayer()) {
            return PlaceholderResult.invalid((String)"No player context");
        }
        UUID playerUUID = ctx.player().method_5667();
        int tokens = TokenManager.getTokens(playerUUID);
        return PlaceholderResult.value((class_2561)class_2561.method_43470((String)this.formatTokens(tokens)));
    }

    private String formatBalance(double balance) {
        if (balance >= 1.0E9) {
            return String.format("%.2fB", balance / 1.0E9);
        }
        if (balance >= 1000000.0) {
            return String.format("%.2fM", balance / 1000000.0);
        }
        if (balance >= 1000.0) {
            return String.format("%.2fK", balance / 1000.0);
        }
        return String.format("%.2f", balance);
    }

    private String formatTokens(int tokens) {
        double value = tokens;
        if (value >= 1.0E9) {
            return String.format("%.2fb", value / 1.0E9);
        }
        if (value >= 1000000.0) {
            return String.format("%.2fm", value / 1000000.0);
        }
        if (value >= 1000.0) {
            return String.format("%.2fk", value / 1000.0);
        }
        return String.format("%.2f", value);
    }
}

