/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappaessentials.bounty;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class BountyManager {
    public static final Map<UUID, BountyData> bounties = new HashMap<UUID, BountyData>();
    private static final File BOUNTY_FILE = new File("config/KappaEssentials/bounties.json");

    public static void setBounty(UUID target, UUID setter, int amount) {
        bounties.put(target, new BountyData(amount, setter));
        BountyManager.saveBounties();
    }

    public static int getBounty(UUID target) {
        BountyData data = bounties.get(target);
        return data != null ? data.amount() : 0;
    }

    public static UUID getSetter(UUID target) {
        BountyData data = bounties.get(target);
        return data != null ? data.setter() : null;
    }

    public static boolean hasBounty(UUID target) {
        return bounties.containsKey(target);
    }

    public static Set<UUID> getAllBountiedPlayers() {
        return bounties.keySet();
    }

    public static void removeBounty(UUID target) {
        bounties.remove(target);
        BountyManager.saveBounties();
    }

    public static void saveBounties() {
        try (FileWriter writer = new FileWriter(BOUNTY_FILE);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            HashMap<String, BountyData> stringMap = new HashMap<String, BountyData>();
            for (Map.Entry<UUID, BountyData> entry : bounties.entrySet()) {
                stringMap.put(entry.getKey().toString(), entry.getValue());
            }
            gson.toJson(stringMap, (Appendable)writer);
        }
        catch (IOException e) {
            System.err.println("Failed to save bounties: " + e.getMessage());
        }
    }

    public static void loadBounties() {
        if (!BOUNTY_FILE.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(BOUNTY_FILE);){
            Gson gson = new Gson();
            Type type = new TypeToken<Map<String, BountyData>>(){}.getType();
            Map stringMap = (Map)gson.fromJson((Reader)reader, type);
            bounties.clear();
            for (Map.Entry entry : stringMap.entrySet()) {
                bounties.put(UUID.fromString((String)entry.getKey()), (BountyData)entry.getValue());
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load bounties: " + e.getMessage());
        }
    }

    public record BountyData(int amount, UUID setter) {
    }
}

