/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappaessentials.homes;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.kappasmp.kappaessentials.homes.HomeManager;
import net.kappasmp.kappaessentials.util.TaskScheduler;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2709;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class HomeCommand {
    private static final int TELEPORT_DELAY_SECONDS = 5;
    private static final SuggestionProvider<class_2168> HOME_NAME_SUGGESTIONS = (context, builder) -> {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        Map<String, HomeManager.HomeData> homes = HomeManager.getHomes(player);
        homes.keySet().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"home").then(class_2170.method_9244((String)"homeName", (ArgumentType)StringArgumentType.string()).suggests(HOME_NAME_SUGGESTIONS).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            String homeName = StringArgumentType.getString((CommandContext)context, (String)"homeName");
            HomeManager.HomeData home = HomeManager.getHome(player, homeName);
            if (home == null) {
                player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7cHome not found: " + homeName)), false);
                return 1;
            }
            class_3218 targetWorld = server.method_3847(home.dimension);
            if (targetWorld == null) {
                player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7cWorld not found: " + String.valueOf(home.dimension.method_29177()))), false);
                return 1;
            }
            class_2338 pos = home.pos;
            class_1923 chunkPos = new class_1923(pos);
            for (int second = 1; second <= 5; ++second) {
                int timeLeft = 5 - second + 1;
                int delayTicks = second * 20;
                TaskScheduler.scheduleMessage(player, delayTicks, () -> player.method_7353((class_2561)class_2561.method_43470((String)("\u00a77Teleporting in \u00a7e" + timeLeft + "\u00a77...")), false));
            }
            TaskScheduler.scheduleTeleport(player, 100, () -> CompletableFuture.runAsync(() -> targetWorld.method_8497(chunkPos.field_9181, chunkPos.field_9180), (Executor)server).thenRunAsync(() -> {
                HomeCommand.teleportSafely(player, targetWorld, pos);
                player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7aTeleported to home: " + homeName)), false);
            }, (Executor)server), homeName);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"sethome").then(class_2170.method_9244((String)"homeName", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String homeName;
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            if (HomeManager.getHome(player, homeName = StringArgumentType.getString((CommandContext)context, (String)"homeName")) != null) {
                player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7cHome already exists: " + homeName)), false);
                return 1;
            }
            class_5321 worldKey = player.method_37908().method_27983();
            class_2338 pos = player.method_24515();
            HomeManager.HomeData home = new HomeManager.HomeData(pos, (class_5321<class_1937>)worldKey);
            HomeManager.setHome(player, homeName, home);
            player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7aHome '" + homeName + "' has been set.")), false);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"delhome").then(class_2170.method_9244((String)"homeName", (ArgumentType)StringArgumentType.string()).suggests(HOME_NAME_SUGGESTIONS).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            String homeName = StringArgumentType.getString((CommandContext)context, (String)"homeName");
            Map<String, HomeManager.HomeData> homes = HomeManager.getHomes(player);
            if (!homes.containsKey(homeName)) {
                player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7cHome not found: " + homeName)), false);
                return 1;
            }
            HomeManager.removeHome(player, homeName);
            player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7aHome '" + homeName + "' has been deleted.")), false);
            return 1;
        })));
    }

    private static void teleportSafely(class_3222 player, class_3218 world, class_2338 pos) {
        double x = (double)pos.method_10263() + 0.5;
        double y = pos.method_10264();
        double z = (double)pos.method_10260() + 0.5;
        if (player.method_37908() != world) {
            player.method_48105(world, x, y, z, EnumSet.noneOf(class_2709.class), player.method_36454(), player.method_36455());
        } else {
            player.field_13987.method_14363(x, y, z, player.method_36454(), player.method_36455());
        }
    }
}

