/*
 * Decompiled with CFR 0.152.
 */
package net.kappasmp.kappaessentials.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class TaskScheduler {
    private static final Map<UUID, ScheduledTeleport> activeTeleports = new HashMap<UUID, ScheduledTeleport>();
    private static final List<ScheduledMessage> scheduledMessages = new LinkedList<ScheduledMessage>();

    public static void scheduleTeleport(class_3222 player, int delayTicks, Runnable action, String homeName) {
        class_2338 currentPos = player.method_24515();
        activeTeleports.put(player.method_5667(), new ScheduledTeleport(delayTicks, action, currentPos, (class_2561)class_2561.method_43470((String)("\u00a7cTeleport to \u00a7e" + homeName + "\u00a7c cancelled: you moved."))));
    }

    public static void scheduleMessage(class_3222 player, int delayTicks, Runnable action) {
        scheduledMessages.add(new ScheduledMessage(player.method_5667(), delayTicks, action));
    }

    static {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            class_3222 player;
            Iterator<Map.Entry<UUID, ScheduledTeleport>> teleportIterator = activeTeleports.entrySet().iterator();
            while (teleportIterator.hasNext()) {
                Map.Entry<UUID, ScheduledTeleport> entry = teleportIterator.next();
                ScheduledTeleport task = entry.getValue();
                player = server.method_3760().method_14602(entry.getKey());
                if (player == null || player.method_14239()) {
                    teleportIterator.remove();
                    continue;
                }
                if (!player.method_24515().equals((Object)task.startPos)) {
                    player.method_7353(task.cancelMessage, false);
                    teleportIterator.remove();
                    continue;
                }
                --task.delay;
                if (task.delay > 0) continue;
                task.action.run();
                teleportIterator.remove();
            }
            Iterator<ScheduledMessage> messageIterator = scheduledMessages.iterator();
            while (messageIterator.hasNext()) {
                ScheduledMessage message = messageIterator.next();
                --message.delay;
                if (message.delay > 0) continue;
                player = server.method_3760().method_14602(message.playerId);
                if (player != null && !player.method_14239()) {
                    message.action.run();
                }
                messageIterator.remove();
            }
        });
    }

    private static class ScheduledTeleport {
        int delay;
        Runnable action;
        class_2338 startPos;
        class_2561 cancelMessage;

        ScheduledTeleport(int delay, Runnable action, class_2338 startPos, class_2561 cancelMessage) {
            this.delay = delay;
            this.action = action;
            this.startPos = startPos;
            this.cancelMessage = cancelMessage;
        }
    }

    private static class ScheduledMessage {
        UUID playerId;
        int delay;
        Runnable action;

        ScheduledMessage(UUID playerId, int delay, Runnable action) {
            this.playerId = playerId;
            this.delay = delay;
            this.action = action;
        }
    }
}

