package net.kappasmp.kappaessentials.command;

import com.mojang.brigadier.CommandDispatcher;
import net.kappasmp.kappaessentials.token.TokenManager;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import java.util.*;

public class AfkCommand {
    private static final Map<UUID, Long> afkStartTimes = new HashMap<>();
    private static final Map<UUID, class_2338> afkStartPositions = new HashMap<>();
    private static final Map<UUID, Timer> afkTimers = new HashMap<>();

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(class_2170.method_9247("afk")
                .executes(context -> {
                    class_3222 player = context.getSource().method_44023();
                    UUID uuid = player.method_5667();

                    if (afkTimers.containsKey(uuid)) {
                        player.method_7353(class_2561.method_43470("§cYou're already AFK! Use §e/afk stop §cto cancel it."), false);
                        return 0;
                    }

                    class_2338 startPos = player.method_24515();
                    afkStartTimes.put(uuid, System.currentTimeMillis());
                    afkStartPositions.put(uuid, startPos);

                    player.method_7353(class_2561.method_43470("§6You are now AFK. §7Stay still for §61 minute§7 to earn a token."), false);

                    Timer timer = new Timer();
                    afkTimers.put(uuid, timer);

                    timer.scheduleAtFixedRate(new TimerTask() {
                        @Override
                        public void run() {
                            class_3222 stillPlayer = player.method_5682().method_3760().method_14602(uuid);
                            if (stillPlayer == null) return;

                            class_2338 currentPos = stillPlayer.method_24515();
                            class_2338 originalPos = afkStartPositions.get(uuid);

                            if (currentPos.equals(originalPos)) {
                                TokenManager.giveTokens(uuid, 1);
                                stillPlayer.method_7353(class_2561.method_43470("§6+1 Token! §7Thanks for being AFK."), false);
                            } else {
                                stillPlayer.method_7353(class_2561.method_43470("§cYou moved! §7No token for you."), false);
                                cancelAfk(uuid);
                            }
                        }
                    }, 60_000, 60_000);

                    return 1;
                })
                .then(class_2170.method_9247("stop")
                        .executes(context -> {
                            class_3222 player = context.getSource().method_44023();
                            UUID uuid = player.method_5667();

                            if (!afkTimers.containsKey(uuid)) {
                                player.method_7353(class_2561.method_43470("§cYou're not AFK right now."), false);
                                return 0;
                            }

                            cancelAfk(uuid);
                            player.method_7353(class_2561.method_43470("§7You are no longer AFK."), false);
                            return 1;
                        }))
        );
    }

    private static void cancelAfk(UUID uuid) {
        Timer timer = afkTimers.remove(uuid);
        if (timer != null) {
            timer.cancel();
        }
        afkStartTimes.remove(uuid);
        afkStartPositions.remove(uuid);
    }
}
