package net.kappasmp.kappaessentials.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.kappasmp.kappaessentials.economy.BalanceManager;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class BalTopCommand {

    public static void register(com.mojang.brigadier.CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(LiteralArgumentBuilder.<class_2168>literal("baltop")
                .requires(source -> source.method_9259(0))
                .executes(context -> execute(context.getSource()))
        );
    }

    private static int execute(class_2168 source) {
        var topBalances = BalanceManager.getTopBalances(10);
        source.method_45068(class_2561.method_43470("§6§lTop 10 Balances:"));
        int rank = 1;
        for (Map.Entry<UUID, Integer> entry : topBalances) {
            String name = getPlayerName(source, entry.getKey());
            String formatted = formatBalance(entry.getValue());
            source.method_45068(class_2561.method_43470("§6§l" + rank + ". §7" + name + " - $" + formatted));
            rank++;
        }
        return Command.SINGLE_SUCCESS;
    }

    private static String formatBalance(int balance) {
        double value = balance;
        if (value >= 1_000_000_000) {
            return String.format("%.2fb", value / 1_000_000_000);
        } else if (value >= 1_000_000) {
            return String.format("%.2fm", value / 1_000_000);
        } else if (value >= 1_000) {
            return String.format("%.2fk", value / 1_000);
        } else {
            return String.format("%.2f", value);
        }
    }

    private static String getPlayerName(class_2168 source, UUID uuid) {
        var player = source.method_9211().method_3760().method_14602(uuid);
        if (player != null) {
            return player.method_5477().getString();
        } else {
            Optional<com.mojang.authlib.GameProfile> profile = source.method_9211().method_3793().method_14512(uuid);
            return profile.map(com.mojang.authlib.GameProfile::getName).orElse(uuid.toString().substring(0, 8));
        }
    }
}
