package net.kappasmp.kappaessentials.command;

import com.mojang.brigadier.CommandDispatcher;
import net.kappasmp.kappaessentials.config.ConfigManager;
import net.kappasmp.kappaessentials.economy.BalanceManager;
import net.kappasmp.kappaessentials.manager.ShopManager;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.kappasmp.kappaessentials.homes.HomeManager;

public class ReloadCommand {

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(class_2170.method_9247("kappaessentials")
                .then(class_2170.method_9247("reload")
                        .requires(source -> source.method_9259(2)) // Only ops
                        .executes(context -> {
                            class_2168 source = context.getSource();

                            try {
                                // Reload config
                                ConfigManager.load();

                                // Reload data files
                                BalanceManager.loadBalances();
                                BalanceManager.loadItemPrices();
                                ShopManager.loadShop();
                                HomeManager.loadHomes();

                                int categories = ShopManager.getMainMenu().size();
                                int shops = ShopManager.getShopCount();

                                source.method_9226(() ->
                                        class_2561.method_43470("§aKappaEssentials reloaded successfully. §7Loaded §e" + categories + " §7categories and §e" + shops + " §7shops."), false);
                            } catch (Exception e) {
                                e.printStackTrace();
                                source.method_9213(class_2561.method_43470("§cFailed to reload some components. Check console for details."));
                            }

                            return 1;
                        })
                )
        );
    }
}
