package net.kappasmp.kappaessentials.economy;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class BalCommand {

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(class_2170.method_9247("bal")
                .executes(context -> {
                    class_2168 source = context.getSource();
                    return showBalance(source, source.method_44023().method_5667(), source.method_9214());
                })
                .then(class_2170.method_9244("player", StringArgumentType.string())
                        .executes(context -> {
                            String playerName = StringArgumentType.getString(context, "player");
                            class_2168 source = context.getSource();

                            class_3222 onlinePlayer = source.method_9211().method_3760().method_14566(playerName);
                            if (onlinePlayer != null) {
                                return showBalance(source, onlinePlayer.method_5667(), onlinePlayer.method_5477().getString());
                            } else {
                                Optional<GameProfile> profile = source.method_9211().method_3793().method_14515(playerName);
                                if (profile.isPresent()) {
                                    UUID uuid = profile.get().getId();
                                    return showBalance(source, uuid, playerName);
                                } else {
                                    source.method_9226(() -> class_2561.method_43470("Player not found."), false);
                                    return 0;
                                }
                            }
                        })
                )
        );
    }

    private static int showBalance(class_2168 source, UUID uuid, String name) {
        int balance = BalanceManager.getBalance(uuid);
        String formattedBalance = formatBalance(balance);

        class_5250 message = class_2561.method_43470("Balance of ")
                .method_10862(class_2583.field_24360.method_36139(0xBEBEBE))
                .method_10852(class_2561.method_43470(name).method_10862(class_2583.field_24360.method_36139(0xFF8300)))
                .method_10852(class_2561.method_43470(" is ").method_10862(class_2583.field_24360.method_36139(0xBEBEBE)))
                .method_10852(class_2561.method_43470("$" + formattedBalance).method_10862(class_2583.field_24360.method_36139(0xFF8300)));

        source.method_9226(() -> message, false);
        return 1;
    }

    private static String formatBalance(int balance) {
        if (balance >= 1_000_000_000) {
            return String.format("%.1fB", balance / 1_000_000_000.0);
        } else if (balance >= 1_000_000) {
            return String.format("%.1fM", balance / 1_000_000.0);
        } else if (balance >= 1_000) {
            return String.format("%.1fK", balance / 1_000.0);
        } else {
            return String.format("%d", balance);
        }
    }
}
