package net.kappasmp.kappaessentials.economy;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class PayCommand {

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(class_2170.method_9247("pay")
                .then(class_2170.method_9244("player", StringArgumentType.string())
                        .then(class_2170.method_9244("amount", IntegerArgumentType.integer(1))
                                .executes(context -> {
                                    class_2168 source = context.getSource();
                                    class_3222 sender = source.method_44023();
                                    String targetName = StringArgumentType.getString(context, "player");
                                    int amount = IntegerArgumentType.getInteger(context, "amount");

                                    class_3222 target = source.method_9211().method_3760().method_14566(targetName);
                                    if (target == null) {
                                        source.method_9226(() -> class_2561.method_43470("§cPlayer not found."), false);
                                        return 0;
                                    }

                                    if (sender.method_5667().equals(target.method_5667())) {
                                        source.method_9226(() -> class_2561.method_43470("§cYou can't pay yourself!"), false);
                                        return 0;
                                    }

                                    int senderBalance = BalanceManager.getBalance(sender.method_5667());
                                    if (senderBalance < amount) {
                                        source.method_9226(() -> class_2561.method_43470("§cYou don't have enough money!"), false);
                                        return 0;
                                    }

                                    // Perform the transfer
                                    BalanceManager.addBalance(sender.method_5667(), -amount);
                                    BalanceManager.addBalance(target.method_5667(), amount);

                                    source.method_9226(() -> class_2561.method_43470("§aYou paid §e" + target.method_5477().getString() + " §a$" + amount), false);
                                    target.method_64398(class_2561.method_43470("§aYou received §a$" + amount + " §afrom §e" + sender.method_5477().getString()));

                                    return 1;
                                }))));
    }
}
