package net.kappasmp.kappaessentials.economy;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class SellCommand {

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(class_2170.method_9247("sell")
                .executes(context -> {
                    class_3222 player = context.getSource().method_44023();
                    class_1799 heldItem = player.method_6047();

                    // If the player isn't holding anything
                    if (heldItem.method_7960()) {
                        player.method_7353(
                                class_2561.method_43470("You're not holding any item to sell.")
                                        .method_10862(class_2583.field_24360.method_36139(0xBEBEBE)),
                                false
                        );
                        return 0;
                    }

                    String itemId = class_7923.field_41178.method_10221(heldItem.method_7909()).toString();
                    int count = heldItem.method_7947();
                    int pricePerItem = BalanceManager.getItemPrice(itemId);

                    // If the item can't be sold
                    if (pricePerItem <= 0) {
                        player.method_7353(
                                class_2561.method_43470("You cannot sell this item.")
                                        .method_10862(class_2583.field_24360.method_36139(0xBEBEBE)),
                                false
                        );
                        return 0;
                    }

                    int totalValue = pricePerItem * count;
                    heldItem.method_7934(count);
                    BalanceManager.addBalance(player.method_5667(), totalValue);

                    // Create feedback message
                    class_5250 message = class_2561.method_43470("Sold ")
                            .method_10862(class_2583.field_24360.method_36139(0xBEBEBE))
                            .method_10852(class_2561.method_43470(count + "x ")
                                    .method_10862(class_2583.field_24360.method_36139(0xFF8300)))
                            .method_10852(class_2561.method_43470(itemId.split(":")[1] + " ")
                                    .method_10862(class_2583.field_24360.method_36139(0xBEBEBE)))
                            .method_10852(class_2561.method_43470("for ")
                                    .method_10862(class_2583.field_24360.method_36139(0xBEBEBE)))
                            .method_10852(class_2561.method_43470("$" + totalValue)
                                    .method_10862(class_2583.field_24360.method_36139(0xFF8300)));

                    player.method_7353(message, false);
                    return 1;
                })
                // New subcommand for selling the inventory
                .then(class_2170.method_9247("inventory")
                        .executes(context -> {
                            class_3222 player = context.getSource().method_44023();
                            int totalValue = 0;

                            // Loop through player's inventory
                            for (int i = 0; i < player.method_31548().method_5439(); i++) {
                                class_1799 stack = player.method_31548().method_5438(i);

                                if (!stack.method_7960()) {
                                    String itemId = class_7923.field_41178.method_10221(stack.method_7909()).toString();
                                    int pricePerItem = BalanceManager.getItemPrice(itemId);

                                    // If the item can't be sold, skip it
                                    if (pricePerItem <= 0) {
                                        continue;
                                    }

                                    int itemTotalValue = pricePerItem * stack.method_7947();
                                    totalValue += itemTotalValue;
                                    stack.method_7934(stack.method_7947());  // Decrease the item count in the inventory
                                }
                            }

                            if (totalValue > 0) {
                                BalanceManager.addBalance(player.method_5667(), totalValue);

                                class_5250 message = class_2561.method_43470("Sold all items in your inventory for ")
                                        .method_10862(class_2583.field_24360.method_36139(0xBEBEBE))
                                        .method_10852(class_2561.method_43470("$" + totalValue)
                                                .method_10862(class_2583.field_24360.method_36139(0xFF8300)));

                                player.method_7353(message, false);
                            } else {
                                player.method_7353(
                                        class_2561.method_43470("You don't have any sellable items in your inventory.")
                                                .method_10862(class_2583.field_24360.method_36139(0xBEBEBE)),
                                        false
                                );
                            }

                            return 1;
                        })
                )
        );
    }
}
