package net.kappasmp.kappaessentials.gui;

import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.api.gui.AnvilInputGui;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import net.kappasmp.kappaessentials.bounty.BountyManager;
import net.kappasmp.kappaessentials.economy.BalanceManager;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import java.text.NumberFormat;
import java.util.UUID;
import java.util.Optional;
import java.util.List;
import java.util.stream.Collectors;

public class BountyGui extends SimpleGui {

    public BountyGui(class_3222 player) {
        super(class_3917.field_17327, player, false);
        this.setTitle(class_2561.method_43470("> ʙᴏᴜɴᴛɪᴇꜱ").method_27692(class_124.field_1063));

        int slot = 0;
        var bountiedPlayers = BountyManager.getAllBountiedPlayers();

        // Show placeholder if no bounties
        if (bountiedPlayers.isEmpty()) {
            this.setSlot(22, new GuiElementBuilder(class_1802.field_8077)
                    .setName(class_2561.method_43470("No bounties yet!").method_27692(class_124.field_1063))
                    .addLoreLine(class_2561.method_43470("§7Use the anvil below to add one.")));
        } else {
            // Sort players by bounty amount (highest first)
            List<UUID> sortedBountiedPlayers = bountiedPlayers.stream()
                    .sorted((uuid1, uuid2) -> Integer.compare(BountyManager.getBounty(uuid2), BountyManager.getBounty(uuid1)))
                    .collect(Collectors.toList());

            // Loop through sorted bountied players
            for (UUID targetUUID : sortedBountiedPlayers) {
                String name = getPlayerName(player.method_5682().method_3739(), targetUUID);
                int amount = BountyManager.getBounty(targetUUID);

                // Format the bounty amount
                String formattedAmount = formatMoney(amount);

                // Set player head and bounty info
                this.setSlot(slot++, new GuiElementBuilder(class_1802.field_8575)
                        .setSkullOwner(targetUUID.toString())  // Fetch the correct player head by UUID
                        .setName(class_2561.method_43470("☠ " + name).method_27692(class_124.field_1065))
                        .addLoreLine(class_2561.method_43470("§7ʙᴏᴜɴᴛʏ: §c" + formattedAmount))
                        .setCallback((i, t, a, gui) -> {
                            player.method_7353(class_2561.method_43470("ᴛᴀʀɢᴇᴛ: " + name + " ʜᴀѕ ᴀ $" + formattedAmount + " bounty."), false);
                        }));
            }
        }

        // Button to set new bounty
        this.setSlot(49, new GuiElementBuilder(class_1802.field_8782)
                .setName(class_2561.method_43470("➕ ѕᴇᴛ ɴᴇᴡ ʙᴏᴜɴᴛɪᴇ").method_27695(class_124.field_1060, class_124.field_1067))
                .addLoreLine(class_2561.method_43470("ᴄʟɪᴄᴋ ᴛᴏ ѕᴇᴛ ᴀ ʙᴏᴜɴᴛɪᴇ ᴏɴ ᴀ ᴘʟᴀʏᴇʀ."))
                .setCallback((i, t, a, gui) -> {
                    player.method_7346();
                    new SelectBountyTargetGui(player).open();
                }));
    }

    // Money formatting method (K = thousand, M = million, B = billion)
    public static String formatMoney(int amount) {
        if (amount >= 1_000_000_000) {
            return (amount / 1_000_000_000) + "B";
        } else if (amount >= 1_000_000) {
            return (amount / 1_000_000) + "M";
        } else if (amount >= 1_000) {
            return (amount / 1_000) + "K";
        }
        return String.valueOf(amount);  // For numbers less than 1000
    }

    // Method to get the player name, considering both online and offline players
    private static String getPlayerName(class_2168 source, UUID uuid) {
        var player = source.method_9211().method_3760().method_14602(uuid);
        if (player != null) {
            return player.method_5477().getString();
        } else {
            Optional<com.mojang.authlib.GameProfile> profile = source.method_9211().method_3793().method_14512(uuid);
            return profile.map(com.mojang.authlib.GameProfile::getName).orElse(uuid.toString().substring(0, 8));
        }
    }

    // GUI to choose which player to place a bounty on
    public static class SelectBountyTargetGui extends SimpleGui {

        public SelectBountyTargetGui(class_3222 player) {
            super(class_3917.field_17327, player, false);
            this.setTitle(class_2561.method_43470("> ѕᴇʟᴇᴄᴛ ᴛᴀʀɢᴇᴛ").method_27692(class_124.field_1063));

            int slot = 0;
            for (class_3222 target : player.method_5682().method_3760().method_14571()) {
                if (target.method_5667().equals(player.method_5667())) continue;

                int amount = BountyManager.getBounty(target.method_5667());
                String formattedAmount = NumberFormat.getInstance().format(amount);

                this.setSlot(slot++, new GuiElementBuilder(class_1802.field_8575)
                        .setSkullOwner(target.method_5477().getString()) // Use name string
                        .setName(class_2561.method_43470("☠ " + target.method_5477().getString()).method_27692(class_124.field_1065))
                        .addLoreLine(class_2561.method_43470("§7Bounty: §c$" + formattedAmount))
                        .setCallback((i, t, a, gui) -> {
                            player.method_7353(class_2561.method_43470("Target: " + target.method_5477().getString() + " has a $" + formattedAmount + " bounty."), false);
                            player.method_7346();
                            openAmountInput(player, target);
                        }));
            }
        }
        private void openAmountInput(class_3222 source, class_3222 target) {
            AnvilInputGui inputGui = new AnvilInputGui(source, false);

            inputGui.setSlot(1, new GuiElementBuilder(class_1802.field_8407)
                    .setName(class_2561.method_43470("§eᴇɴᴛᴇʀ ʙᴏᴜɴᴛɪᴇꜱ ᴀᴍᴏᴜɴᴛ"))
                    .addLoreLine(class_2561.method_43470("§7Type an amount and click here."))
                    .setCallback((index, type, action, gui) -> {
                        String text = inputGui.getInput();
                        try {
                            int amount = Integer.parseInt(text);
                            if (amount <= 0) throw new NumberFormatException();

                            if (BalanceManager.getBalance(source.method_5667()) < amount) {
                                source.method_64398(class_2561.method_43470("§cYou don't have enough balance to set this bounty."));
                                return;
                            }

                            //  Updated to include the source (setter)
                            BountyManager.setBounty(target.method_5667(), source.method_5667(), amount);

                            // Deduct balance
                            BalanceManager.addBalance(source.method_5667(), -amount);

                            source.method_64398(class_2561.method_43470("§aʙᴏᴜɴᴛʏ ѕᴇᴛ ᴏɴ §e" + target.method_5477().getString() + " §afor §c$" + BountyGui.formatMoney(amount)));
                        } catch (NumberFormatException e) {
                            source.method_64398(class_2561.method_43470("§cɪɴᴠᴀʟɪᴅ ʙᴏᴜɴᴛʏ ᴀᴍᴏᴜɴᴛ."));
                        }
                        gui.close();
                    }));

            inputGui.open();
        }
    }
}