package net.kappasmp.kappaessentials.gui;

import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import net.kappasmp.kappaessentials.manager.ShopManager;
import net.kappasmp.kappaessentials.model.ShopCategory;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_7923;

public class ShopGui extends SimpleGui {

    public ShopGui(class_3222 player) {
        super(class_3917.field_17326, player, false);
        this.setTitle(class_2561.method_43470("§8> ѕʜᴏᴘ"));

        for (ShopCategory category : ShopManager.getMainMenu()) {
            class_2960 id = class_2960.method_12829(category.icon);
            if (id == null || !class_7923.field_41178.method_10250(id)) {
                System.err.println("[ShopGui] Invalid icon ID: " + category.icon);
                continue;
            }

            class_1792 icon = class_7923.field_41178.method_63535(id);
            this.setSlot(category.slot, new GuiElementBuilder(icon)
                    .setName(class_2561.method_43470(category.name))
                    .setCallback((index, type, action, gui) -> {
                        player.method_7353(class_2561.method_43470("Opening " + category.name + "..."), false);
                        new ShopSubGui(player, category.shopId).open();
                    }));
        }
    }
}
