package net.kappasmp.kappaessentials.gui;

import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import net.kappasmp.kappaessentials.economy.BalanceManager;
import net.kappasmp.kappaessentials.manager.ShopManager;
import net.kappasmp.kappaessentials.model.ShopItem;
import net.kappasmp.kappaessentials.model.ShopShop;
import net.kappasmp.kappaessentials.token.TokenManager;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_7923;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class ShopSubGui extends SimpleGui {

    public ShopSubGui(class_3222 player, String shopId) {
        super(class_3917.field_17326, player, false);

        Optional<ShopShop> optionalShop = ShopManager.getShopById(shopId);
        if (optionalShop.isEmpty()) {
            this.setTitle(class_2561.method_43470("§cShop Not Found"));
            return;
        }

        ShopShop shop = optionalShop.get();
        this.setTitle(class_2561.method_43470(shop.title));

        // Fill background
        class_1792 filler = class_7923.field_41178.method_63535(class_2960.method_12829("minecraft:gray_stained_glass_pane"));
        for (int i = 0; i < 27; i++) {
            this.setSlot(i, new GuiElementBuilder(filler).setName(class_2561.method_43470("")));
        }

        for (ShopItem item : shop.items) {
            class_2960 itemId = class_2960.method_12829(item.id);
            if (itemId == null || !class_7923.field_41178.method_10250(itemId)) {
                System.err.println("[Shop] Invalid item ID in config: " + item.id);
                continue;
            }

            class_1792 mcItem = class_7923.field_41178.method_63535(itemId);

            GuiElementBuilder builder = new GuiElementBuilder(mcItem)
                    .setName(class_2561.method_43470("§f" + mcItem.method_63680().getString()))
                    .setLore(List.of(
                            class_2561.method_43470("§7Click to purchase"),
                            class_2561.method_43470("§6" + (shop.currency.equalsIgnoreCase("tokens") ? "Token Cost" : "💰 Cost") + ": §e" + item.price),
                            class_2561.method_43470("§6Amount: §e" + item.amount)
                    ))
                    .setCallback((index, type, action, gui) -> handlePurchase(player, shop.currency, item));

            this.setSlot(item.slot, builder);
        }
    }

    private void handlePurchase(class_3222 player, String currency, ShopItem item) {
        UUID uuid = player.method_5667();
        boolean paid = currency.equalsIgnoreCase("tokens")
                ? TokenManager.withdrawTokens(uuid, item.price)
                : BalanceManager.withdrawBalance(uuid, item.price);

        if (!paid) {
            player.method_7353(class_2561.method_43470("§cYou do not have enough " + (currency.equalsIgnoreCase("tokens") ? "Tokens" : "Money") + "."), false);
            return;
        }

        String command = (item.customCommand != null && !item.customCommand.isEmpty())
                ? item.customCommand.replace("%player%", player.method_5477().getString())
                : "give " + player.method_5477().getString() + " " + item.id + " " + item.amount;

        player.method_5682().method_3734().method_44252(player.method_5682().method_3739(), command);
        player.method_7353(class_2561.method_43470("§aPurchase successful!"), false);
    }
}
