package net.kappasmp.kappaessentials.homes;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import net.kappasmp.kappaessentials.homes.HomeManager.HomeData;
import net.kappasmp.kappaessentials.util.TaskScheduler;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2709;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class HomeCommand {

    private static final int TELEPORT_DELAY_SECONDS = 5;

    private static final SuggestionProvider<class_2168> HOME_NAME_SUGGESTIONS = (context, builder) -> {
        class_3222 player = context.getSource().method_44023();
        Map<String, HomeData> homes = HomeManager.getHomes(player);
        homes.keySet().forEach(builder::suggest);
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<class_2168> dispatcher) {

        // /home <homeName>
        dispatcher.register(class_2170.method_9247("home")
                .then(class_2170.method_9244("homeName", StringArgumentType.string())
                        .suggests(HOME_NAME_SUGGESTIONS)
                        .executes(context -> {
                            class_3222 player = context.getSource().method_44023();
                            MinecraftServer server = context.getSource().method_9211();
                            String homeName = StringArgumentType.getString(context, "homeName");

                            HomeData home = HomeManager.getHome(player, homeName);
                            if (home == null) {
                                player.method_7353(class_2561.method_43470("§cHome not found: " + homeName), false);
                                return 1;
                            }

                            class_3218 targetWorld = server.method_3847(home.dimension);
                            if (targetWorld == null) {
                                player.method_7353(class_2561.method_43470("§cWorld not found: " + home.dimension.method_29177()), false);
                                return 1;
                            }

                            class_2338 pos = home.pos;
                            class_1923 chunkPos = new class_1923(pos);

                            // Send countdown messages (safe even if player moves)
                            for (int second = 1; second <= TELEPORT_DELAY_SECONDS; second++) {
                                int timeLeft = TELEPORT_DELAY_SECONDS - second + 1;
                                int delayTicks = second * 20;

                                TaskScheduler.scheduleMessage(player, delayTicks, () ->
                                        player.method_7353(class_2561.method_43470("§7Teleporting in §e" + timeLeft + "§7..."), false)
                                );
                            }

                            // Schedule teleport after delay (cancel if player moves)
                            TaskScheduler.scheduleTeleport(player, TELEPORT_DELAY_SECONDS * 20, () -> {
                                CompletableFuture.runAsync(() -> {
                                    targetWorld.method_8497(chunkPos.field_9181, chunkPos.field_9180);
                                }, server).thenRunAsync(() -> {
                                    teleportSafely(player, targetWorld, pos);
                                    player.method_7353(class_2561.method_43470("§aTeleported to home: " + homeName), false);
                                }, server);
                            }, homeName);

                            return 1;
                        })
                )
        );

        // /sethome <homeName>
        dispatcher.register(class_2170.method_9247("sethome")
                .then(class_2170.method_9244("homeName", StringArgumentType.string())
                        .executes(context -> {
                            class_3222 player = context.getSource().method_44023();
                            String homeName = StringArgumentType.getString(context, "homeName");

                            if (HomeManager.getHome(player, homeName) != null) {
                                player.method_7353(class_2561.method_43470("§cHome already exists: " + homeName), false);
                                return 1;
                            }

                            class_5321<class_1937> worldKey = player.method_37908().method_27983();
                            class_2338 pos = player.method_24515();
                            HomeData home = new HomeData(pos, worldKey);
                            HomeManager.setHome(player, homeName, home);

                            player.method_7353(class_2561.method_43470("§aHome '" + homeName + "' has been set."), false);
                            return 1;
                        })
                )
        );

        // /delhome <homeName>
        dispatcher.register(class_2170.method_9247("delhome")
                .then(class_2170.method_9244("homeName", StringArgumentType.string())
                        .suggests(HOME_NAME_SUGGESTIONS)
                        .executes(context -> {
                            class_3222 player = context.getSource().method_44023();
                            String homeName = StringArgumentType.getString(context, "homeName");

                            Map<String, HomeData> homes = HomeManager.getHomes(player);
                            if (!homes.containsKey(homeName)) {
                                player.method_7353(class_2561.method_43470("§cHome not found: " + homeName), false);
                                return 1;
                            }

                            HomeManager.removeHome(player, homeName);
                            player.method_7353(class_2561.method_43470("§aHome '" + homeName + "' has been deleted."), false);
                            return 1;
                        })
                )
        );
    }

    /**
     * Teleports the player safely across dimensions.
     */
    private static void teleportSafely(class_3222 player, class_3218 world, class_2338 pos) {
        double x = pos.method_10263() + 0.5;
        double y = pos.method_10264();
        double z = pos.method_10260() + 0.5;

        if (player.method_51469() != world) {
            player.method_48105(
                    world, x, y, z,
                    EnumSet.noneOf(class_2709.class),
                    player.method_36454(), player.method_36455(),
                    false
            );
        } else {
            player.field_13987.method_14363(
                    x, y, z,
                    player.method_36454(), player.method_36455()
            );
        }
    }
}
