package net.kappasmp.kappaessentials.teleport;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2709;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import java.util.*;

public class HomeTeleportScheduler {
    private static final List<TeleportTask> tasks = new ArrayList<>();

    public static void tick(MinecraftServer server) {
        Iterator<TeleportTask> iterator = tasks.iterator();

        while (iterator.hasNext()) {
            TeleportTask task = iterator.next();

            if (!task.player.method_24515().equals(task.startPos)) {
                task.player.method_7353(class_2561.method_43470("§cYou moved! Teleportation cancelled."), false);
                iterator.remove();
                continue;
            }

            if (task.delayTicks == 0) {
                class_3218 targetWorld = server.method_3847(task.dimension);
                if (targetWorld == null) {
                    task.player.method_7353(class_2561.method_43470("§cError: world not found!"), false);
                    iterator.remove();
                    continue;
                }

                task.player.method_48105(
                        targetWorld,
                        task.pos.method_10263() + 0.5,
                        task.pos.method_10264(),
                        task.pos.method_10260() + 0.5,
                        EnumSet.noneOf(class_2709.class),
                        task.player.method_36454(),
                        task.player.method_36455(),
                        false
                );

                task.player.method_7353(class_2561.method_43470("§aTeleported to home '" + task.name + "'!"), false);
                iterator.remove();
                continue;
            }

            if (task.delayTicks % 20 == 0) {
                int secondsLeft = task.delayTicks / 20;
                task.player.method_7353(class_2561.method_43470("§7Teleporting in " + secondsLeft + "..."), false);
            }

            task.delayTicks--;
        }
    }

    public static void queue(class_3222 player, class_2338 pos, class_5321<class_1937> dimension, String name) {
        tasks.add(new TeleportTask(player, pos, dimension, name));
    }

    private static class TeleportTask {
        class_3222 player;
        class_2338 pos;
        class_5321<class_1937> dimension;
        String name;
        int delayTicks = 5 * 20;
        class_2338 startPos;

        TeleportTask(class_3222 player, class_2338 pos, class_5321<class_1937> dimension, String name) {
            this.player = player;
            this.pos = pos;
            this.dimension = dimension;
            this.name = name;
            this.startPos = player.method_24515();
        }
    }
}
