package net.kappasmp.kappaessentials.teleport;

import java.util.*;
import net.minecraft.class_3222;

public class TeleportRequestManager {

    public enum Type { TPA, TPAHERE }

    private static class Request {
        public final class_3222 requester;
        public final Type type;

        public Request(class_3222 requester, Type type) {
            this.requester = requester;
            this.type = type;
        }
    }

    private static final Map<UUID, Request> requests = new HashMap<>();

    public static void sendRequest(class_3222 from, class_3222 to, Type type) {
        requests.put(to.method_5667(), new Request(from, type));
    }

    public static class_3222 getRequester(class_3222 receiver) {
        Request req = requests.get(receiver.method_5667());
        return req != null ? req.requester : null;
    }

    public static Type getType(class_3222 receiver) {
        Request req = requests.get(receiver.method_5667());
        return req != null ? req.type : null;
    }

    public static void clearRequest(class_3222 receiver) {
        requests.remove(receiver.method_5667());
    }

    public static boolean hasRequest(class_3222 receiver) {
        return requests.containsKey(receiver.method_5667());
    }
}
